<?php
/**
 * Test HTML-Import
 */

echo "<h1>🧪 HTML Import Test</h1>";
echo "<pre>";

if (!isset($_GET['file'])) {
    echo "❌ Keine Datei angegeben!\n\n";
    echo "Verwendung: test_html_import.php?file=pfad/zur/html-datei.html\n";
    exit;
}

$file = $_GET['file'];

if (!file_exists($file)) {
    echo "❌ Datei nicht gefunden: $file\n";
    exit;
}

echo "📄 Datei: $file\n";
echo "📏 Größe: " . filesize($file) . " bytes\n\n";

$html = file_get_contents($file);
echo "HTML-Vorschau (erste 1000 Zeichen):\n";
echo substr($html, 0, 1000) . "...\n\n";

// Parse HTML
libxml_use_internal_errors(true);
$dom = new DOMDocument();
$dom->loadHTML($html);
$xpath = new DOMXPath($dom);

echo "=== Parse Test ===\n\n";

// Finde alle Tabellen
$tables = $xpath->query('//table');
echo "Tabellen gefunden: " . $tables->length . "\n\n";

// Finde alle Zeilen
$rows = $xpath->query('//tr');
echo "Zeilen gefunden: " . $rows->length . "\n\n";

// Analysiere erste 10 Zeilen
$count = 0;
foreach ($rows as $row) {
    if ($count++ >= 10) break;
    
    $cells = $xpath->query('./td', $row);
    
    echo "Zeile $count: {$cells->length} Zellen\n";
    
    if ($cells->length > 0) {
        for ($i = 0; $i < min(3, $cells->length); $i++) {
            $content = trim($cells->item($i)->textContent ?? '');
            echo "  [$i]: " . substr($content, 0, 30) . "\n";
        }
    }
    echo "\n";
}

// Finde spezifische Elemente
echo "=== Suche nach Kennzeichen ===\n";
$kennzeichenRows = $xpath->query('//td[contains(text(), "K") or contains(text(), "M") or contains(text(), "B")]');
echo "Potential Kennzeichen-Zellen: " . $kennzeichenRows->length . "\n";

if ($kennzeichenRows->length > 0) {
    echo "\nErste 5 Kennzeichen:\n";
    foreach ($kennzeichenRows as $i => $cell) {
        if ($i >= 5) break;
        $text = trim($cell->textContent ?? '');
        if (strlen($text) >= 2 && strlen($text) <= 10) {
            echo "  - $text\n";
        }
    }
}

echo "</pre>";

