<?php
/**
 * Test: Vollautomatische RESY API-Integration
 */

echo "🧪 Test: RESY Auto-API\n";
echo "=====================\n\n";

// Test API-Aufruf
$url = "http://localhost/boxenstop/api/get_stored_wheelsets.php?autohaus_id=1";
$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Status: " . $httpCode . "\n";
echo "Response:\n";
echo str_repeat("=", 50) . "\n";

$data = json_decode($response, true);

if ($data) {
    echo "✅ API antwortet\n";
    echo "Source: " . ($data['source'] ?? 'unknown') . "\n";
    echo "Count: " . ($data['count'] ?? 0) . "\n";
    echo "Autohaus: " . ($data['autohaus'] ?? 'unknown') . "\n";
    echo "From RESY: " . (isset($data['fetched_from_resy']) && $data['fetched_from_resy'] ? '✅ JA' : '❌ NEIN') . "\n";
} else {
    echo "❌ JSON Parse Error\n";
    echo $response . "\n";
}

echo "\n" . str_repeat("=", 50) . "\n";
echo "✅ Test abgeschlossen!\n";

