@echo off
setlocal enabledelayedexpansion

:: ===========================================
:: Boxxenstopp Server mit automatischem Cleanup
:: ===========================================

echo.
echo ==========================================
echo    Boxxenstopp Server wird gestartet...
echo ==========================================
echo.

:: Arbeitsverzeichnis setzen
cd /d "C:\xampp\htdocs\boxenstop"

:: Log-Datei für Cleanup-Aktivitäten
set "CLEANUP_LOG=logs\cleanup_%date:~-4,4%%date:~-10,2%%date:~-7,2%.log"

:: Log-Verzeichnis erstellen falls nicht vorhanden
if not exist "logs" mkdir logs

:: Ersten Cleanup sofort ausführen
echo [%date% %time%] Führe initialen Token-Cleanup aus...
echo [%date% %time%] Führe initialen Token-Cleanup aus... >> "%CLEANUP_LOG%"
"C:\xampp\php\php.exe" cleanup_expired_tokens.php >> "%CLEANUP_LOG%" 2>&1

if %errorlevel% equ 0 (
    echo [%date% %time%] Initialer Token-Cleanup erfolgreich abgeschlossen.
    echo [%date% %time%] Initialer Token-Cleanup erfolgreich abgeschlossen. >> "%CLEANUP_LOG%"
) else (
    echo [%date% %time%] FEHLER beim initialen Token-Cleanup! Error Level: %errorlevel%
    echo [%date% %time%] FEHLER beim initialen Token-Cleanup! Error Level: %errorlevel% >> "%CLEANUP_LOG%"
)

echo.
echo ==========================================
echo    Starte PHP Development Server...
echo ==========================================
echo.


:: PHP Server wird nicht mehr gestartet, damit Apache Port 80 nutzen kann

:: Cleanup-Schleife (läuft parallel zum Server)
:cleanup_loop
echo.
echo [%date% %time%] Warte 24 Stunden bis zum nächsten Cleanup...
echo [%date% %time%] Warte 24 Stunden bis zum nächsten Cleanup... >> "%CLEANUP_LOG%"

:: 24 Stunden warten (86400 Sekunden)
timeout /t 86400 /nobreak >nul

:: Cleanup ausführen
echo.
echo [%date% %time%] Führe Token-Cleanup aus...
echo [%date% %time%] Führe Token-Cleanup aus... >> "%CLEANUP_LOG%"

"C:\xampp\php\php.exe" cleanup_expired_tokens.php >> "%CLEANUP_LOG%" 2>&1

if %errorlevel% equ 0 (
    echo [%date% %time%] Token-Cleanup erfolgreich abgeschlossen.
    echo [%date% %time%] Token-Cleanup erfolgreich abgeschlossen. >> "%CLEANUP_LOG%"
) else (
    echo [%date% %time%] FEHLER beim Token-Cleanup! Error Level: %errorlevel%
    echo [%date% %time%] FEHLER beim Token-Cleanup! Error Level: %errorlevel% >> "%CLEANUP_LOG%"
)

:: Zurück zur Schleife
goto cleanup_loop
