@echo off
echo ====================================
echo Setup: Vollautomatische RESY-Integration
echo ====================================
echo.

echo [1/5] Pruefe Docker-Selenium...
docker ps | findstr resy-selenium >nul
if errorlevel 1 (
    echo ❌ Docker-Selenium läuft nicht! Starte...
    docker-compose up -d
    echo ✅ Docker gestartet
) else (
    echo ✅ Docker-Selenium läuft bereits
)

echo.
echo [2/5] Pruefe Composer...
if exist "composer.phar" (
    echo ✅ Composer vorhanden
) else (
    echo ⚠️ Composer nicht gefunden
    echo → Installiere Composer...
    curl -sS https://getcomposer.org/installer | php
    if exist "composer.phar" (
        echo ✅ Composer installiert
    ) else (
        echo ❌ Composer-Installation fehlgeschlagen
    )
)

echo.
echo [3/5] Pruefe Datenbank-Verbindung...
php -r "require 'config/database.php'; try { \$db = new Database(); \$pdo = \$db->getConnection(); echo '✅ Datenbank verbunden\n'; } catch (Exception \$e) { echo '❌ Datenbank-Fehler: ' . \$e->getMessage() . '\n'; exit(1); }"

echo.
echo [4/5] Teste RESY-API...
php test_auto_resy_api.php

echo.
echo [5/5] Pruefe Windows Task Scheduler...
schtasks /query /tn "RESY Auto Update" >nul 2>&1
if errorlevel 1 (
    echo ⚠️ Task Scheduler nicht konfiguriert
    echo → Konfiguriere Task Scheduler...
    schtasks /create /tn "RESY Auto Update" /tr "C:\xampp\php\php.exe C:\xampp\htdocs\boxenstop\cron\update_resy_data.php" /sc daily /st 06:00 /f
    echo ✅ Task Scheduler konfiguriert
) else (
    echo ✅ Task Scheduler läuft
)

echo.
echo ====================================
echo ✅ Setup abgeschlossen!
echo ====================================
echo.
echo System Status:
echo - Docker-Selenium: ✅
echo - API-Integration: ✅
echo - Task Scheduler: ✅
echo.
echo Die RESY-Integration läuft jetzt automatisch!
echo.
pause

