<?php
/**
 * SQL ausführen - Temporäres Skript
 */

require_once 'config/database.php';

$db = new Database();
$conn = $db->getConnection();

echo "Füge Verifizierungsfelder hinzu...\n";

try {
    // Füge Spalten hinzu, wenn sie noch nicht existieren
    $conn->exec("ALTER TABLE users ADD COLUMN IF NOT EXISTS verification_status ENUM('pending', 'approved', 'rejected') DEFAULT 'pending'");
    $conn->exec("ALTER TABLE users ADD COLUMN IF NOT EXISTS verification_document VARCHAR(500) NULL");
    $conn->exec("ALTER TABLE users ADD COLUMN IF NOT EXISTS verification_reason TEXT NULL");
    $conn->exec("ALTER TABLE users ADD COLUMN IF NOT EXISTS verified_by INT NULL");
    $conn->exec("ALTER TABLE users ADD COLUMN IF NOT EXISTS verified_at DATETIME NULL");
    
    // Index hinzufügen
    $conn->exec("CREATE INDEX IF NOT EXISTS idx_verification_status ON users(verification_status)");
    
    // Bestehende User als approved markieren
    $conn->exec("UPDATE users SET verification_status = 'approved' WHERE verification_status IS NULL OR verification_status = ''");
    
    echo "✅ Verifizierungsfelder erfolgreich hinzugefügt!\n";
    echo "Alle bestehenden User wurden auf 'approved' gesetzt.\n";
    
} catch (Exception $e) {
    echo "❌ Fehler: " . $e->getMessage() . "\n";
    echo "Versuch es manuell:\n";
    echo "mysql -u Admin50 -p boxxenstopp < database/add_verification_fields.sql\n";
}

