// RESY Daemon - Läuft permanent im Hintergrund
const http = require('http');

let lastFetchTime = 0;
const CACHE_DURATION = 60000; // 1 Minute
let cachedData = null;

// Starte Selenium Session einmal
async function startSession() {
    return new Promise((resolve, reject) => {
        const body = JSON.stringify({
            capabilities: {
                alwaysMatch: {
                    browserName: 'chrome',
                    'goog:chromeOptions': {
                        args: ['--no-sandbox', '--disable-dev-shm-usage', '--headless=new']
                    }
                }
            }
        });
        
        const req = http.request({
            hostname: 'localhost',
            port: 4444,
            path: '/wd/hub/session',
            method: 'POST',
            headers: { 'Content-Type': 'application/json', 'Content-Length': body.length }
        }, (res) => {
            let data = '';
            res.on('data', chunk => data += chunk);
            res.on('end', () => {
                const sessionId = JSON.parse(data).value.sessionId;
                console.log('Session erstellt:', sessionId);
                resolve(sessionId);
            });
        });
        
        req.on('error', reject);
        req.write(body);
        req.end();
    });
}

// Login einmalig
async function doLogin(sessionId) {
    const username = 'D.ULUDAG';
    const password = 'Ikizler123!';
    
    // Navigate
    await sendRequest(sessionId, 'POST', '/url', { url: 'https://resy.dtm-reifen.de/index.php?m=login&a=login' });
    await wait(3000);
    
    // Fill username
    const userElem = await findElement(sessionId, 'id', 'InputUser');
    await sendKeys(sessionId, userElem, username);
    await wait(500);
    
    // Fill password
    const passElem = await findElement(sessionId, 'id', 'InputPass');
    await sendKeys(sessionId, passElem, password);
    await wait(500);
    
    // Click login
    const btnElem = await findElement(sessionId, 'name', 'button');
    await click(sessionId, btnElem);
    await wait(10000); // Lange Wartezeit für Login
    
    console.log('✅ Login versucht');
}

function findElement(sessionId, strategy, selector) {
    return new Promise((resolve) => {
        const body = JSON.stringify({ using: strategy, value: selector });
        
        http.request({
            hostname: 'localhost',
            port: 4444,
            path: `/wd/hub/session/${sessionId}/element`,
            method: 'POST',
            headers: { 'Content-Type': 'application/json', 'Content-Length': body.length }
        }, (res) => {
            let data = '';
            res.on('data', chunk => data += chunk);
            res.on('end', () => {
                resolve(JSON.parse(data).value.ELEMENT);
            });
        }).write(body).end();
    });
}

function sendKeys(sessionId, elementId, text) {
    return sendRequest(sessionId, 'POST', `/element/${elementId}/value`, { text });
}

function click(sessionId, elementId) {
    return sendRequest(sessionId, 'POST', `/element/${elementId}/click`, {});
}

function sendRequest(sessionId, method, path, data) {
    return new Promise((resolve) => {
        const body = JSON.stringify(data);
        const req = http.request({
            hostname: 'localhost',
            port: 4444,
            path: `/wd/hub/session/${sessionId}${path}`,
            method: method,
            headers: { 'Content-Type': 'application/json', 'Content-Length': body.length }
        }, (res) => resolve());
        
        req.write(body);
        req.end();
    });
}

function wait(ms) {
    return new Promise(r => setTimeout(r, ms));
}

// Server
const server = http.createServer((req, res) => {
    res.setHeader('Content-Type', 'application/json');
    
    if (req.url === '/fetch' && req.method === 'GET') {
        fetchWheelsets(res);
    } else {
        res.writeHead(404);
        res.end(JSON.stringify({ error: 'Not Found' }));
    }
});

let globalSessionId = null;

async function fetchWheelsets(response) {
    try {
        if (!globalSessionId) {
            globalSessionId = await startSession();
            await doLogin(globalSessionId);
        }
        
        // Navigate to wheelsets
        await sendRequest(globalSessionId, 'POST', '/url', { 
            url: 'https://resy.dtm-reifen.de/index.php?m=wheelset&a=search&FN=WheelsetSearch&KD_ID=453&STATUS_ID=20' 
        });
        await wait(8000);
        
        // Get page source
        const html = await new Promise((resolve) => {
            http.request({
                hostname: 'localhost',
                port: 4444,
                path: `/wd/hub/session/${globalSessionId}/source`,
                method: 'GET'
            }, (res) => {
                let data = '';
                res.on('data', chunk => data += chunk);
                res.on('end', () => resolve(JSON.parse(data).value));
            }).end();
        });
        
        // Parse
        const wheelsets = parseWheelsets(html);
        
        response.writeHead(200);
        response.end(JSON.stringify({
            success: true,
            count: wheelsets.length,
            wheelsets: wheelsets
        }));
        
    } catch (error) {
        response.writeHead(500);
        response.end(JSON.stringify({ success: false, error: error.message }));
    }
}

function parseWheelsets(html) {
    const wheelsets = [];
    const rowRegex = /<tr[^>]*>([\s\S]*?)<\/tr>/g;
    let match;
    let rowNum = 0;
    
    while ((match = rowRegex.exec(html)) !== null && rowNum++ < 100) {
        const row = match[1];
        const cells = [];
        const cellRegex = /<td[^>]*>([\s\S]*?)<\/td>/g;
        let cellMatch;
        
        while ((cellMatch = cellRegex.exec(row)) !== null) {
            cells.push(cellMatch[1]);
        }
        
        if (cells.length >= 2) {
            const kennzeichen = cells[0].replace(/<[^>]*>/g, '').trim();
            
            if (kennzeichen.length >= 2 && kennzeichen.length <= 20 && kennzeichen !== 'Kennzeichen') {
                wheelsets.push({
                    kennzeichen,
                    satznummer: cells[1].replace(/<[^>]*>/g, '').trim() || '',
                    marke: 'RESY',
                    modell: '',
                    oe_nummer: ''
                });
            }
        }
        rowNum++;
    }
    
    return wheelsets;
}

server.listen(3000, () => {
    console.log('✅ RESY Daemon läuft auf Port 3000');
});

