@echo off
REM ============================================
REM RESY Auto-Import Script
REM Lädt Credentials aus Datenbank und importiert
REM ============================================

setlocal enabledelayedexpansion

REM Projekt-Verzeichnis
set PROJECT_DIR=%~dp0
cd /d "%PROJECT_DIR%"

REM PHP Pfad
set PHP_PATH=C:\xampp\php\php.exe

REM Prüfe ob PHP existiert
if not exist "%PHP_PATH%" (
    echo [FEHLER] PHP nicht gefunden: %PHP_PATH%
    echo.
    pause
    exit /b 1
)

REM Prüfe ob PHP-Script existiert
if not exist "%PROJECT_DIR%resy_auto_import.php" (
    echo [FEHLER] PHP-Script nicht gefunden: resy_auto_import.php
    echo.
    pause
    exit /b 1
)

echo ============================================
echo RESY Auto-Import - Start
echo Zeit: %date% %time%
echo ============================================
echo.
echo Projekt-Verzeichnis: %PROJECT_DIR%
echo PHP-Pfad: %PHP_PATH%
echo PHP-Script: %PROJECT_DIR%resy_auto_import.php
echo.

REM WICHTIG: Verwende PHP-Script das die Datenbank lädt!
echo [Info] Lade Credentials aus Datenbank...
echo.

REM Führe PHP-Script aus und zeige Output
"%PHP_PATH%" "resy_auto_import.php"

set EXIT_CODE=!errorlevel!

echo.
if !EXIT_CODE! equ 0 (
    echo ============================================
    echo [OK] Import abgeschlossen
    echo ============================================
) else (
    echo ============================================
    echo [FEHLER] Import fehlgeschlagen (Exit Code: !EXIT_CODE!)
    echo ============================================
)

echo.
echo Zeit: %date% %time%
echo.
echo Druecken Sie eine beliebige Taste zum Beenden...
pause >nul

endlocal
exit /b !EXIT_CODE!

