<?php
/**
 * Parse RESY HTML
 */

$htmlFile = __DIR__ . '/temp/resy_1761640650650.html';

if (!file_exists($htmlFile)) {
    echo "Datei nicht gefunden!\n";
    exit;
}

$html = file_get_contents($htmlFile);
echo "📄 HTML gelesen: " . strlen($html) . " bytes\n\n";

// Parse
libxml_use_internal_errors(true);
$dom = new DOMDocument();
$dom->loadHTML($html);
$xpath = new DOMXPath($dom);

$rows = $xpath->query('//tr');
echo "Tabellenzeilen gefunden: " . $rows->length . "\n\n";

$wheelsets = [];
foreach ($rows as $row) {
    $cells = $xpath->query('./td', $row);
    
    if ($cells->length >= 2) {
        $kennzeichen = trim($cells->item(0)->textContent ?? '');
        
        if (strlen($kennzeichen) >= 2 && strlen($kennzeichen) <= 20) {
            $wheelsets[] = [
                'kennzeichen' => $kennzeichen,
                'satznummer' => trim($cells->item(1)->textContent ?? '')
            ];
        }
    }
}

echo "✅ Reifensätze extrahiert: " . count($wheelsets) . "\n\n";

if (count($wheelsets) > 0) {
    echo "Erste 10:\n";
    foreach (array_slice($wheelsets, 0, 10) as $i => $ws) {
        echo "  " . ($i+1) . ". " . $ws['kennzeichen'] . " - " . $ws['satznummer'] . "\n";
    }
}

