const { chromium } = require('playwright');

async function exportCells() {
    const browser = await chromium.launch({
        headless: false,
        channel: 'chrome'
    });
    
    const page = await browser.newPage();
    
    try {
        console.log('🚀 Starte RESY-Login...\n');
        
        // Login
        await page.goto('https://resy.dtm-reifen.de/index.php?m=login&a=login', {
            waitUntil: 'networkidle'
        });
        
        await page.fill('#InputUser', 'D.ULUDAG');
        await page.fill('#InputPass', 'Ikizler123!');
        await page.click('button[type="submit"]');
        await page.waitForTimeout(8000);
        
        // Navigate to search
        await page.goto('https://resy.dtm-reifen.de/resyweb/index.php?m=wheelset&a=search', {
            waitUntil: 'networkidle',
            timeout: 30000
        });
        
        await page.waitForTimeout(3000);
        
        // Filter
        await page.selectOption('#WheelKD_ID', '453');
        await page.waitForTimeout(1000);
        await page.selectOption('#WheelSTATUS_ID', '20');
        await page.waitForTimeout(1000);
        await page.click('button[type="submit"]');
        await page.waitForTimeout(8000);
        
        // Exportiere ALLE cells aus der ersten Zeile
        const firstRowData = await page.evaluate(() => {
            const firstRow = document.querySelector('table.ResultTable tbody tr:first-child');
            if (!firstRow) return null;
            
            const cells = firstRow.querySelectorAll('td');
            const data = {
                totalCells: cells.length,
                cells: []
            };
            
            cells.forEach((cell, index) => {
                const cellData = {
                    index: index,
                    html: cell.innerHTML,
                    text: cell.textContent.trim(),
                    length: cell.textContent.trim().length
                };
                
                data.cells.push(cellData);
            });
            
            return data;
        });
        
        console.log('\n📊 EXFERTIERTE CELLS VON ERSTER ZEILE:\n');
        console.log(`Gesamt: ${firstRowData.totalCells} Zellen\n`);
        console.log('='.repeat(100));
        
        firstRowData.cells.forEach((cell, i) => {
            console.log(`\nCELL ${i}:`);
            console.log(`  Text: "${cell.text.substring(0, 100)}${cell.text.length > 100 ? '...' : ''}"`);
            console.log(`  Länge: ${cell.length} Zeichen`);
            console.log(`  HTML (erste 200 Zeichen): "${cell.html.substring(0, 200)}..."`);
        });
        
        console.log('\n' + '='.repeat(100));
        
        // JSON Output
        console.log('\n📋 JSON:');
        console.log(JSON.stringify(firstRowData, null, 2));
        
    } catch (error) {
        console.error('❌ Fehler:', error.message);
    } finally {
        await browser.close();
    }
}

exportCells();

