<?php
// download_ics.php: Dynamisch generierte ICS-Datei für den Launch-Termin
header('Content-Type: text/calendar; charset=utf-8');
header('Content-Disposition: attachment; filename="be-launch.ics"');

require_once __DIR__ . '/config/database.php';
$db = new Database();
$conn = $db->getConnection();

$stmt = $conn->prepare("SELECT setting_value FROM settings WHERE setting_key = 'launch_date'");
$stmt->execute();
$launch_date = $stmt->fetchColumn();

// Optional: Freitext, wenn kein Datum gesetzt ist
$stmt2 = $conn->prepare("SELECT setting_value FROM settings WHERE setting_key = 'launch_date_text'");
$stmt2->execute();
$launch_date_text = $stmt2->fetchColumn();

if ($launch_date) {
    $start = $launch_date . 'T080000';
    $end = $launch_date . 'T180000';
    $summary = 'Start der neuen B&E Onlinewelt';
    $desc = 'Die neue B&E Onlinewelt ist ab heute live! Jetzt entdecken und exklusive Angebote sichern.';
    $location = 'Online unter www.be-gruppe.de';
    $uid = 'be-launch-' . md5($launch_date) . '@be-gruppe.de';
    $dtstamp = gmdate('Ymd\THis\Z');
    echo "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//B&E Gruppe//DE\nBEGIN:VEVENT\nUID:$uid\nDTSTAMP:$dtstamp\nDTSTART:$start\nDTEND:$end\nSUMMARY:$summary\nDESCRIPTION:$desc\nLOCATION:$location\nEND:VEVENT\nEND:VCALENDAR\n";
    exit;
}

// Kein Datum: Zeige stattdessen Freitext als ICS-Notiz
$summary = $launch_date_text ?: 'Start der neuen B&E Onlinewelt';
$desc = 'Das genaue Launch-Datum wird noch bekanntgegeben.';
$dtstamp = gmdate('Ymd\THis\Z');
$uid = 'be-launch-nodate@be-gruppe.de';
echo "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//B&E Gruppe//DE\nBEGIN:VEVENT\nUID:$uid\nDTSTAMP:$dtstamp\nSUMMARY:$summary\nDESCRIPTION:$desc\nEND:VEVENT\nEND:VCALENDAR\n";
