<?php
/**
 * Detaillierte HTML-Analyse für eine RESY-Antwort
 */

$tempDir = sys_get_temp_dir();
$htmlFile = $tempDir . '/resy_search_updated_direct_lgs_id_9877038.html';

echo "=== DETAILLIERTE HTML-ANALYSE ===\n";
echo "Datei: " . basename($htmlFile) . "\n\n";

if (!file_exists($htmlFile)) {
    echo "❌ Datei nicht gefunden\n";
    exit;
}

$content = file_get_contents($htmlFile);

// Dekomprimiere gzip falls nötig
if (substr($content, 0, 2) === "\x1f\x8b") {
    $content = gzdecode($content);
    echo "✅ Gzip-Daten dekodiert\n";
}

echo "Inhalt-Länge: " . strlen($content) . " Zeichen\n\n";

// Extrahiere wichtige Informationen
echo "=== WICHTIGE INFORMATIONEN ===\n";

// Titel
if (preg_match('/<title[^>]*>(.*?)<\/title>/i', $content, $matches)) {
    echo "Titel: " . trim($matches[1]) . "\n";
}

// Meta-Informationen
if (preg_match_all('/<meta[^>]*>/i', $content, $matches)) {
    echo "Meta-Tags gefunden: " . count($matches[0]) . "\n";
}

// Formulare
if (preg_match_all('/<form[^>]*>(.*?)<\/form>/is', $content, $matches)) {
    echo "Formulare gefunden: " . count($matches[0]) . "\n";
    
    foreach ($matches[0] as $i => $form) {
        echo "Formular " . ($i + 1) . ":\n";
        
        // Action
        if (preg_match('/action=["\']([^"\']*)["\']/', $form, $actionMatch)) {
            echo "  Action: " . $actionMatch[1] . "\n";
        }
        
        // Method
        if (preg_match('/method=["\']([^"\']*)["\']/', $form, $methodMatch)) {
            echo "  Method: " . $methodMatch[1] . "\n";
        }
        
        // Input-Felder
        if (preg_match_all('/<input[^>]*>/i', $form, $inputs)) {
            echo "  Input-Felder: " . count($inputs[0]) . "\n";
            foreach ($inputs[0] as $input) {
                if (preg_match('/name=["\']([^"\']*)["\']/', $input, $nameMatch)) {
                    echo "    - " . $nameMatch[1] . "\n";
                }
            }
        }
    }
}

// Links
if (preg_match_all('/<a[^>]*href=["\']([^"\']*)["\'][^>]*>(.*?)<\/a>/i', $content, $matches)) {
    echo "Links gefunden: " . count($matches[0]) . "\n";
    foreach ($matches[0] as $i => $link) {
        $href = $matches[1][$i];
        $text = trim(strip_tags($matches[2][$i]));
        if (strlen($text) > 50) $text = substr($text, 0, 50) . '...';
        echo "  " . ($i + 1) . ". $href - $text\n";
    }
}

// Suche nach spezifischen RESY-Elementen
echo "\n=== RESY-SPEZIFISCHE ELEMENTE ===\n";
$resyElements = [
    'Wheelset' => 'Wheelset',
    'LGS_ID' => 'LGS_ID',
    'WheelHALTERNAME' => 'WheelHALTERNAME',
    'WheelKENNZEICHEN' => 'WheelKENNZEICHEN',
    'WheelFAHRGESTNR' => 'WheelFAHRGESTNR',
    'WheelsetView' => 'WheelsetView',
    'WheelsetSearch' => 'WheelsetSearch',
    'Anmeldename' => 'Anmeldename',
    'Kennwort' => 'Kennwort',
    'login' => 'login'
];

foreach ($resyElements as $element => $label) {
    $count = substr_count($content, $element);
    if ($count > 0) {
        echo "$label: $count Vorkommen\n";
    }
}

// Suche nach Fehlermeldungen oder Hinweisen
echo "\n=== FEHLERMELDUNGEN UND HINWEISE ===\n";
$errorPatterns = [
    'nicht gefunden' => 'nicht gefunden',
    'keine Ergebnisse' => 'keine Ergebnisse',
    'error' => 'error',
    'fehler' => 'fehler',
    'not found' => 'not found',
    'no results' => 'no results',
    'session' => 'session',
    'timeout' => 'timeout',
    'expired' => 'expired',
    'abgelaufen' => 'abgelaufen'
];

foreach ($errorPatterns as $pattern => $label) {
    if (stripos($content, $pattern) !== false) {
        echo "⚠️ $label gefunden\n";
    }
}

// Zeige einen Ausschnitt des HTML-Inhalts
echo "\n=== HTML-AUSSCHNITT (erste 1000 Zeichen) ===\n";
echo substr($content, 0, 1000) . "\n";

echo "\n=== ANALYSE ABGESCHLOSSEN ===\n";
?>
