<?php
/**
 * Test Script: Setze zufällige Status für Angebote zum Testen
 */

require_once dirname(__DIR__) . '/config/database.php';

try {
    $database = new Database();
    $conn = $database->getConnection();
    
    if (!$conn) {
        throw new Exception("Keine Datenbankverbindung möglich");
    }
    
    echo "Setze Test-Status für Angebote...\n\n";
    
    // Hole alle Angebote
    $stmt = $conn->query("SELECT id, wheelset_number, customer_name, license_plate, status FROM wheelset_offers ORDER BY created_at DESC LIMIT 20");
    $offers = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (count($offers) === 0) {
        echo "Keine Angebote gefunden.\n";
        exit(0);
    }
    
    // Status-Liste für Tests
    $testStatuses = ['accepted', 'declined', 'new_request'];
    
    $updated = 0;
    foreach ($offers as $offer) {
        // Setze zufälligen Test-Status
        $newStatus = $testStatuses[array_rand($testStatuses)];
        
        $stmt = $conn->prepare("UPDATE wheelset_offers SET status = ?, updated_at = NOW() WHERE id = ?");
        $stmt->execute([$newStatus, $offer['id']]);
        
        echo "✅ Angebot #{$offer['id']} (Satz #{$offer['wheelset_number']}, {$offer['customer_name']}): {$offer['status']} → {$newStatus}\n";
        $updated++;
    }
    
    echo "\n✅ {$updated} Angebote aktualisiert!\n";
    
    // Zeige Status-Verteilung
    echo "\nAktuelle Status-Verteilung:\n";
    $stmt = $conn->query("SELECT status, COUNT(*) as count FROM wheelset_offers GROUP BY status");
    $statuses = $stmt->fetchAll(PDO::FETCH_ASSOC);
    foreach ($statuses as $row) {
        echo "  {$row['status']}: {$row['count']}\n";
    }
    
} catch (Exception $e) {
    echo "❌ Fehler: " . $e->getMessage() . "\n";
    exit(1);
}
?>

