-- Migration: stored_wheelsets Tabelle anpassen
-- Neue Struktur basierend auf ANALYZE_EXPORTED_CELLS.md

-- 1. Vorhandene Daten sichern (optional)
-- CREATE TABLE stored_wheelsets_backup AS SELECT * FROM stored_wheelsets;

-- 2. Temporäre Spalten hinzufügen
ALTER TABLE stored_wheelsets 
    ADD COLUMN satznummer VARCHAR(50) AFTER kennzeichen,
    ADD COLUMN haltername VARCHAR(255) AFTER satznummer,
    ADD COLUMN fin VARCHAR(50) AFTER haltername,
    ADD COLUMN eingangsdatum VARCHAR(50) AFTER fin,
    ADD COLUMN rueckliefertermin VARCHAR(50) AFTER eingangsdatum;

-- 3. Daten migrieren (modell -> haltername)
UPDATE stored_wheelsets 
SET haltername = modell,
    satznummer = oe_nummer,
    modell = 'RESY'  -- Marke bleibt RESY

-- 4. Alte Spalten können bleiben oder werden später gelöscht
-- ALTER TABLE stored_wheelsets DROP COLUMN oe_nummer;

-- 5. Neue Struktur:
-- id, autohaus_id, kennzeichen, satznummer, haltername, fin, 
-- eingangsdatum, rueckliefertermin, marke, modell, reifengroesse, 
-- status, archiviert, created_at, updated_at

