-- Tabelle für Reifensatz-Angebote
CREATE TABLE IF NOT EXISTS `wheelset_offers` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `wheelset_number` VARCHAR(50) NOT NULL,
    `autohaus_id` INT(11) NOT NULL,
    `customer_name` VARCHAR(255) DEFAULT NULL,
    `customer_no` VARCHAR(50) DEFAULT NULL,
    `license_plate` VARCHAR(20) DEFAULT NULL,
    `vin` VARCHAR(50) DEFAULT NULL,
    `offer_data` TEXT DEFAULT NULL COMMENT 'JSON mit Reifendaten, Services, etc.',
    `letter_content` TEXT DEFAULT NULL COMMENT 'Brieftext',
    `employee_name` VARCHAR(255) DEFAULT NULL COMMENT 'Name des Mitarbeiters der das Angebot erstellt',
    `token` VARCHAR(64) DEFAULT NULL COMMENT 'Token für Kundenauswahl',
    `token_expires_at` DATETIME DEFAULT NULL COMMENT 'Token-Ablaufzeit (24h)',
    `token_used_at` DATETIME DEFAULT NULL COMMENT 'Wann wurde Token verwendet',
    `email_sent` TINYINT(1) DEFAULT 0 COMMENT 'Wurde Email versendet',
    `email_sent_at` DATETIME DEFAULT NULL,
    `pdf_filename` VARCHAR(255) DEFAULT NULL,
    `status` ENUM('draft', 'sent', 'viewed', 'accepted', 'declined') DEFAULT 'draft',
    `customer_selection` TEXT DEFAULT NULL COMMENT 'JSON mit Kundenauswahl',
    `total_amount` DECIMAL(10,2) DEFAULT NULL,
    `created_by` INT(11) DEFAULT NULL COMMENT 'User ID',
    `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
    `updated_at` DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `idx_wheelset_autohaus` (`wheelset_number`, `autohaus_id`),
    KEY `idx_token` (`token`),
    KEY `idx_status` (`status`),
    KEY `idx_created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

