-- Wheelset Kommentare Tabelle
-- Speichert lokale Kommentare für Radsätze (unabhängig von RESY API)

CREATE TABLE IF NOT EXISTS wheelset_comments (
    id INT AUTO_INCREMENT PRIMARY KEY,
    wheelset_number VARCHAR(50) NOT NULL COMMENT 'RESY Wheelset Nummer',
    autohaus_id INT NOT NULL COMMENT 'Autohaus ID',
    comment TEXT COMMENT 'Kommentar-Text',
    created_by INT COMMENT 'User ID der den Kommentar erstellt hat',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    
    INDEX idx_wheelset_number (wheelset_number),
    INDEX idx_autohaus_id (autohaus_id),
    INDEX idx_created_at (created_at),
    FOREIGN KEY (autohaus_id) REFERENCES autohaus(id) ON DELETE CASCADE,
    FOREIGN KEY (created_by) REFERENCES admin_users(id) ON DELETE SET NULL,
    UNIQUE KEY unique_wheelset_comment (wheelset_number, autohaus_id)
    
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

