-- User Activity Log Tabelle
-- Speichert alle Benutzeraktionen für das Profil

CREATE TABLE IF NOT EXISTS user_activity_log (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    action_type ENUM(
        'profile_updated',
        'vehicle_added',
        'vehicle_updated', 
        'vehicle_deleted',
        'appointment_created',
        'appointment_cancelled',
        'appointment_rescheduled',
        'document_uploaded',
        'password_changed',
        'login',
        'logout'
    ) NOT NULL,
    description TEXT NOT NULL,
    metadata JSON NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    INDEX idx_user_id (user_id),
    INDEX idx_action_type (action_type),
    INDEX idx_created_at (created_at)
);

