-- Stored Wheelsets Tabelle für RESY-Integration
-- Speichert gelagerte Reifensätze aus RESY

CREATE TABLE IF NOT EXISTS stored_wheelsets (
    id INT AUTO_INCREMENT PRIMARY KEY,
    autohaus_id INT NOT NULL,
    kennzeichen VARCHAR(20) NOT NULL,
    marke VARCHAR(100),
    modell VARCHAR(100),
    oe_nummer VARCHAR(50),
    reifengroesse VARCHAR(50),
    status VARCHAR(50) DEFAULT 'gelagert',
    archiviert TINYINT(1) DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    
    INDEX idx_autohaus_id (autohaus_id),
    INDEX idx_kennzeichen (kennzeichen),
    INDEX idx_archiviert (archiviert),
    FOREIGN KEY (autohaus_id) REFERENCES autohaus(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

