-- RESY Sessions Tabelle
-- Speichert Sessions für dauerhafte Verbindungen zum RESY-System

CREATE TABLE IF NOT EXISTS resy_sessions (
    id INT AUTO_INCREMENT PRIMARY KEY,
    autohaus_id INT NOT NULL,
    session_id VARCHAR(255) NOT NULL,
    cookie_data TEXT NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    last_used_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    expires_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_autohaus_id (autohaus_id),
    INDEX idx_expires_at (expires_at),
    UNIQUE KEY unique_autohaus (autohaus_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

