-- Erstelle Tabelle für Autohaus-spezifische Services
CREATE TABLE IF NOT EXISTS autohaus_services (
    id INT AUTO_INCREMENT PRIMARY KEY,
    autohaus_id INT NOT NULL,
    service_name VARCHAR(255) NOT NULL,
    service_description TEXT,
    price DECIMAL(10,2) DEFAULT NULL,
    show_price BOOLEAN DEFAULT TRUE,
    is_active BOOLEAN DEFAULT TRUE,
    sort_order INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (autohaus_id) REFERENCES autohaus(id) ON DELETE CASCADE,
    INDEX idx_autohaus_id (autohaus_id),
    INDEX idx_is_active (is_active),
    INDEX idx_sort_order (sort_order)
);

-- Füge einige Standard-Services für die bestehenden Autohäuser hinzu
INSERT INTO autohaus_services (autohaus_id, service_name, service_description, price, show_price, is_active, sort_order) VALUES
(1, 'Reifenwechsel', 'Kompletter Reifenwechsel mit Montage', 15.00, TRUE, TRUE, 1),
(1, 'Einlagerung', 'Einlagerung der abmontierten Reifen', 25.00, TRUE, TRUE, 2),
(1, 'Frühjahrscheck', 'Umfassender Fahrzeugcheck für den Frühling', 35.00, TRUE, TRUE, 3),
(1, 'Wintercheck', 'Umfassender Fahrzeugcheck für den Winter', 35.00, TRUE, TRUE, 4),
(1, 'Wischerblätter', 'Scheibenwischerblätter mit 20% Rabatt + 1L Scheibenklar', NULL, FALSE, TRUE, 5),

(2, 'Reifenwechsel', 'Kompletter Reifenwechsel mit Montage', 15.00, TRUE, TRUE, 1),
(2, 'Einlagerung', 'Einlagerung der abmontierten Reifen', 25.00, TRUE, TRUE, 2),
(2, 'Frühjahrscheck', 'Umfassender Fahrzeugcheck für den Frühling', 35.00, TRUE, TRUE, 3),
(2, 'Wintercheck', 'Umfassender Fahrzeugcheck für den Winter', 35.00, TRUE, TRUE, 4),
(2, 'Wischerblätter', 'Scheibenwischerblätter mit 20% Rabatt + 1L Scheibenklar', NULL, FALSE, TRUE, 5),

(3, 'Reifenwechsel', 'Kompletter Reifenwechsel mit Montage', 15.00, TRUE, TRUE, 1),
(3, 'Einlagerung', 'Einlagerung der abmontierten Reifen', 25.00, TRUE, TRUE, 2),
(3, 'Frühjahrscheck', 'Umfassender Fahrzeugcheck für den Frühling', 35.00, TRUE, TRUE, 3),
(3, 'Wintercheck', 'Umfassender Fahrzeugcheck für den Winter', 35.00, TRUE, TRUE, 4),
(3, 'Wischerblätter', 'Scheibenwischerblätter mit 20% Rabatt + 1L Scheibenklar', NULL, FALSE, TRUE, 5);
