-- Migration: Füge fehlende Spalten zur wheelset_offers Tabelle hinzu
-- Falls die Tabelle bereits existiert, fügt dieses Script die fehlenden Spalten hinzu

-- Prüfe ob Tabelle existiert und füge fehlende Spalten hinzu
ALTER TABLE `wheelset_offers` 
ADD COLUMN IF NOT EXISTS `customer_no` VARCHAR(50) DEFAULT NULL AFTER `customer_name`,
ADD COLUMN IF NOT EXISTS `customer_name` VARCHAR(255) DEFAULT NULL AFTER `autohaus_id`,
ADD COLUMN IF NOT EXISTS `license_plate` VARCHAR(20) DEFAULT NULL AFTER `customer_no`,
ADD COLUMN IF NOT EXISTS `vin` VARCHAR(50) DEFAULT NULL AFTER `license_plate`,
ADD COLUMN IF NOT EXISTS `offer_data` TEXT DEFAULT NULL COMMENT 'JSON mit Reifendaten, Services, etc.' AFTER `vin`,
ADD COLUMN IF NOT EXISTS `letter_content` TEXT DEFAULT NULL COMMENT 'Brieftext' AFTER `offer_data`,
ADD COLUMN IF NOT EXISTS `employee_name` VARCHAR(255) DEFAULT NULL COMMENT 'Name des Mitarbeiters der das Angebot erstellt' AFTER `letter_content`,
ADD COLUMN IF NOT EXISTS `token` VARCHAR(64) DEFAULT NULL COMMENT 'Token für Kundenauswahl' AFTER `employee_name`,
ADD COLUMN IF NOT EXISTS `token_expires_at` DATETIME DEFAULT NULL COMMENT 'Token-Ablaufzeit (24h)' AFTER `token`,
ADD COLUMN IF NOT EXISTS `token_used_at` DATETIME DEFAULT NULL COMMENT 'Wann wurde Token verwendet' AFTER `token_expires_at`,
ADD COLUMN IF NOT EXISTS `email_sent` TINYINT(1) DEFAULT 0 COMMENT 'Wurde Email versendet' AFTER `token_used_at`,
ADD COLUMN IF NOT EXISTS `email_sent_at` DATETIME DEFAULT NULL AFTER `email_sent`,
ADD COLUMN IF NOT EXISTS `pdf_filename` VARCHAR(255) DEFAULT NULL AFTER `email_sent_at`,
ADD COLUMN IF NOT EXISTS `status` ENUM('draft', 'sent', 'viewed', 'accepted', 'declined') DEFAULT 'draft' AFTER `pdf_filename`,
ADD COLUMN IF NOT EXISTS `customer_selection` TEXT DEFAULT NULL COMMENT 'JSON mit Kundenauswahl' AFTER `status`,
ADD COLUMN IF NOT EXISTS `total_amount` DECIMAL(10,2) DEFAULT NULL AFTER `customer_selection`,
ADD COLUMN IF NOT EXISTS `created_by` INT(11) DEFAULT NULL COMMENT 'User ID' AFTER `total_amount`,
ADD COLUMN IF NOT EXISTS `updated_at` DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP AFTER `created_at`;

-- MySQL unterstützt IF NOT EXISTS nicht für ALTER TABLE ADD COLUMN
-- Alternative: Prüfe und füge nur hinzu wenn nicht vorhanden
-- Falls Spalten bereits existieren, werden Fehler ignoriert

