-- RESY Customer No Feld zur Autohaus-Tabelle hinzufügen
-- Für die neue RESY REST API Integration

USE boxxenstopp;

-- Füge resy_customer_no Feld hinzu, falls es noch nicht existiert
SET @sql = (SELECT IF(
    (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
     WHERE TABLE_SCHEMA = 'boxxenstopp' 
     AND TABLE_NAME = 'autohaus' 
     AND COLUMN_NAME = 'resy_customer_no') = 0,
    'ALTER TABLE autohaus ADD COLUMN resy_customer_no VARCHAR(50) NULL AFTER resy_dealer_id COMMENT ''RESY Kundennummer für REST API''',
    'SELECT ''resy_customer_no column already exists in autohaus'''
));
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Update Test-Autohaus mit Customer No 201 (aus RESY-SCHNITTSTELLE.md)
UPDATE autohaus 
SET resy_customer_no = '201' 
WHERE id = 1 OR name LIKE '%B&E%' OR name LIKE '%B & E%'
LIMIT 1;

