-- Registrierungsquelle hinzufügen für besseres Tracking

ALTER TABLE users ADD COLUMN IF NOT EXISTS registration_source ENUM('web', 'ios', 'android', 'apple_signin', 'unknown') DEFAULT 'unknown';
ALTER TABLE users ADD COLUMN IF NOT EXISTS registration_device VARCHAR(100) NULL;
ALTER TABLE users ADD COLUMN IF NOT EXISTS registration_ip VARCHAR(45) NULL;
ALTER TABLE users ADD COLUMN IF NOT EXISTS last_login_source VARCHAR(100) NULL;
ALTER TABLE users ADD COLUMN IF NOT EXISTS last_login_device VARCHAR(100) NULL;

-- Index für besseres Filtern
CREATE INDEX IF NOT EXISTS idx_registration_source ON users(registration_source);

-- Kommentare hinzufügen
ALTER TABLE users 
MODIFY COLUMN registration_source ENUM('web', 'ios', 'android', 'apple_signin', 'unknown') DEFAULT 'unknown' 
COMMENT 'Registrierungsquelle: web=Web-Browser, ios=iOS App, android=Android App, apple_signin=Apple Sign-In, unknown=Unbekannt';

