-- Add needs_dashboard_setup column to admin_users table
-- This flag indicates if a user needs to configure their dashboard

ALTER TABLE admin_users 
ADD COLUMN needs_dashboard_setup TINYINT(1) DEFAULT 0 AFTER is_active;

-- Set all existing users to not need dashboard setup
UPDATE admin_users SET needs_dashboard_setup = 0 WHERE needs_dashboard_setup IS NULL;

-- Add index for better performance
CREATE INDEX idx_needs_dashboard_setup ON admin_users(needs_dashboard_setup);
