-- Füge admin_user_id Spalte zur users Tabelle hinzu
-- Diese Spalte verknüpft ein Customer-Konto mit einem Admin-Konto

USE boxxenstopp;

-- Prüfe ob Spalte bereits existiert
SELECT COUNT(*) INTO @column_exists 
FROM INFORMATION_SCHEMA.COLUMNS 
WHERE TABLE_SCHEMA = 'boxxenstopp' 
AND TABLE_NAME = 'users' 
AND COLUMN_NAME = 'admin_user_id';

-- Füge Spalte hinzu wenn sie nicht existiert
SET @sql = IF(@column_exists = 0, 
    'ALTER TABLE users ADD COLUMN admin_user_id INT NULL AFTER id, ADD CONSTRAINT fk_users_admin_user FOREIGN KEY (admin_user_id) REFERENCES admin_users(id) ON DELETE SET NULL, ADD INDEX idx_admin_user_id (admin_user_id)',
    'SELECT "Column admin_user_id already exists"');
    
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

