<?php
/**
 * Automatischer RESY-Daten-Update
 * Wird täglich per Cron-Job ausgeführt
 */

// Error Logging aktivieren
ini_set('display_errors', 0);
ini_set('log_errors', 1);
error_reporting(E_ALL);

$logFile = dirname(__DIR__) . '/logs/resy_update_' . date('Y-m-d') . '.log';

function logMessage($message) {
    global $logFile;
    $timestamp = date('Y-m-d H:i:s');
    $logEntry = "[{$timestamp}] {$message}\n";
    file_put_contents($logFile, $logEntry, FILE_APPEND);
    echo $logEntry;
}

logMessage("=== RESY Automatic Update gestartet ===");

require_once dirname(__DIR__) . '/config/database.php';

try {
    $db = new Database();
    $pdo = $db->getConnection();
    
    // Lade alle Autohäuser mit RESY-Credentials
    $stmt = $pdo->query("SELECT id, name, resy_username FROM autohaus WHERE resy_username IS NOT NULL");
    $autohaeuser = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    logMessage("Gefunden: " . count($autohaeuser) . " Autohäuser");
    
    foreach ($autohaeuser as $autohaus) {
        logMessage("Verarbeite: {$autohaus['name']} (ID: {$autohaus['id']})");
        
        try {
            // Lade automatische Integration
            require_once dirname(__DIR__) . '/automatic_resy_integration.php';
            $integration = new AutomaticResyIntegration($autohaus['id']);
            $data = $integration->execute();
            
            logMessage("Erfolgreich: {$autohaus['name']} - " . count($data) . " Reifensätze");
            
        } catch (Exception $e) {
            logMessage("FEHLER bei {$autohaus['name']}: " . $e->getMessage());
        }
        
        // Kurze Pause zwischen den Autohäusern
        sleep(2);
    }
    
    logMessage("=== RESY Automatic Update abgeschlossen ===");
    
} catch (Exception $e) {
    logMessage("KRITISCHER FEHLER: " . $e->getMessage());
    logMessage("Stack Trace: " . $e->getTraceAsString());
    exit(1);
}

logMessage("✅ Update erfolgreich abgeschlossen");
exit(0);

