<?php
/**
 * Cleanup script for expired tokens
 * Run this script daily via cron job
 */

require_once 'config/database.php';

try {
    $database = new Database();
    $conn = $database->getConnection();
    
    if (!$conn) {
        throw new Exception("Keine Datenbankverbindung möglich");
    }
    
    // Delete expired tokens older than 7 days
    $stmt = $conn->prepare("
        DELETE FROM offer_tokens 
        WHERE expires_at < DATE_SUB(NOW(), INTERVAL 7 DAY)
    ");
    $stmt->execute();
    $deletedCount = $stmt->rowCount();
    
    echo "✅ Cleanup abgeschlossen: {$deletedCount} abgelaufene Token gelöscht\n";
    
    // Reset Teams notification status for old offers (older than 30 days)
    $stmt = $conn->prepare("
        UPDATE offer_tracking 
        SET teams_notification_sent = FALSE 
        WHERE created_at < DATE_SUB(NOW(), INTERVAL 30 DAY)
        AND teams_notification_sent = TRUE
    ");
    $stmt->execute();
    $resetCount = $stmt->rowCount();
    
    if ($resetCount > 0) {
        echo "🔄 Teams-Status zurückgesetzt für {$resetCount} alte Angebote\n";
    }
    
    // Show statistics
    $stmt = $conn->query("
        SELECT 
            COUNT(*) as total_tokens,
            COUNT(CASE WHEN expires_at > NOW() THEN 1 END) as active_tokens,
            COUNT(CASE WHEN used_at IS NOT NULL THEN 1 END) as used_tokens,
            COUNT(CASE WHEN expires_at < NOW() AND used_at IS NULL THEN 1 END) as expired_unused_tokens
        FROM offer_tokens
    ");
    $stats = $stmt->fetch(PDO::FETCH_ASSOC);
    
    echo "📊 Token-Statistiken:\n";
    echo "  - Gesamt: {$stats['total_tokens']}\n";
    echo "  - Aktiv: {$stats['active_tokens']}\n";
    echo "  - Verwendet: {$stats['used_tokens']}\n";
    echo "  - Abgelaufen (unbenutzt): {$stats['expired_unused_tokens']}\n";
    
} catch (Exception $e) {
    echo "❌ Fehler beim Cleanup: " . $e->getMessage() . "\n";
}
?>
