<?php
require_once __DIR__ . '/config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();

    $columns = [
        'name' => "ALTER TABLE api_keys ADD COLUMN name VARCHAR(100) NOT NULL AFTER id",
        'key_hash' => "ALTER TABLE api_keys ADD COLUMN key_hash CHAR(64) NOT NULL UNIQUE",
        'secret_hash' => "ALTER TABLE api_keys ADD COLUMN secret_hash CHAR(64) NOT NULL",
        'scopes' => "ALTER TABLE api_keys ADD COLUMN scopes JSON NOT NULL",
        'is_active' => "ALTER TABLE api_keys ADD COLUMN is_active TINYINT(1) NOT NULL DEFAULT 1",
        'rate_limit_per_min' => "ALTER TABLE api_keys ADD COLUMN rate_limit_per_min INT NOT NULL DEFAULT 60",
        'owner_type' => "ALTER TABLE api_keys ADD COLUMN owner_type ENUM('admin','autohaus','service') DEFAULT 'admin'",
        'owner_id' => "ALTER TABLE api_keys ADD COLUMN owner_id INT NULL",
        'created_at' => "ALTER TABLE api_keys ADD COLUMN created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP",
        'last_used_at' => "ALTER TABLE api_keys ADD COLUMN last_used_at TIMESTAMP NULL"
    ];

    foreach ($columns as $col => $alter) {
        $stmt = $conn->prepare("SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'api_keys' AND COLUMN_NAME = ?");
        $stmt->execute([$col]);
        if (!$stmt->fetch()) {
            try { $conn->exec($alter); echo "Added column: $col\n"; } catch (Throwable $e) { echo "Skip $col: ".$e->getMessage()."\n"; }
        }
    }

    echo "Migration OK\n";
} catch (Throwable $e) {
    echo "ERROR: ".$e->getMessage()."\n";
    exit(1);
}
