<?php
$filename = $_GET['filename'] ?? '';

if (empty($filename)) {
    http_response_code(400);
    echo 'Kein Dateiname angegeben';
    exit;
}

// Decode filename
$filename = urldecode($filename);
$filename = basename($filename); // Sicherheit: nur Dateiname, kein Pfad

// Verschiedene mögliche Pfade prüfen
$possiblePaths = [
    '../uploads/offers/' . $filename,
    '../uploads/' . $filename,
    '../temp/' . $filename,
    '../' . $filename,
    $filename
];

$filepath = null;
foreach ($possiblePaths as $path) {
    if (file_exists($path)) {
        $filepath = $path;
        break;
    }
}

// Falls nicht gefunden, suche nach ähnlichen Dateinamen
if (!$filepath) {
    $uploadDir = '../uploads/offers/';
    if (is_dir($uploadDir)) {
        $files = scandir($uploadDir);
        $pdfFiles = array_filter($files, function($file) {
            return pathinfo($file, PATHINFO_EXTENSION) === 'pdf';
        });
        
        // Suche nach ähnlichen Dateinamen
        $searchPattern = preg_replace('/[^a-zA-Z0-9._-]/', '_', $filename);
        $searchPattern = strtolower($searchPattern);
        
        foreach ($pdfFiles as $file) {
            $filePattern = preg_replace('/[^a-zA-Z0-9._-]/', '_', $file);
            $filePattern = strtolower($filePattern);
            
            // Prüfe ob Dateiname ähnlich ist (ohne Zeitstempel)
            if (strpos($filePattern, 'angebot_') === 0 && 
                strpos($filePattern, '_' . date('Y-m-d')) !== false) {
                $filepath = $uploadDir . $file;
                break;
            }
        }
    }
}

if (!$filepath) {
    http_response_code(404);
    echo '<!DOCTYPE html>
    <html>
    <head>
        <title>PDF nicht gefunden</title>
        <style>
            body { font-family: Arial, sans-serif; text-align: center; padding: 50px; }
            .error { color: #dc3545; }
            .info { color: #6c757d; margin-top: 20px; }
        </style>
    </head>
    <body>
        <h1 class="error">PDF-Datei nicht gefunden</h1>
        <p>Die Datei "' . htmlspecialchars($filename) . '" konnte nicht gefunden werden.</p>
        <div class="info">
            <p>Geprüfte Pfade:</p>
            <ul style="text-align: left; display: inline-block;">
                <li>../uploads/offers/' . htmlspecialchars($filename) . '</li>
                <li>../uploads/' . htmlspecialchars($filename) . '</li>
                <li>../temp/' . htmlspecialchars($filename) . '</li>
                <li>../' . htmlspecialchars($filename) . '</li>
                <li>' . htmlspecialchars($filename) . '</li>
            </ul>
            <p>Verfügbare PDF-Dateien:</p>
            <ul style="text-align: left; display: inline-block;">';
            
            $uploadDir = '../uploads/offers/';
            if (is_dir($uploadDir)) {
                $files = scandir($uploadDir);
                $pdfFiles = array_filter($files, function($file) {
                    return pathinfo($file, PATHINFO_EXTENSION) === 'pdf';
                });
                
                foreach ($pdfFiles as $file) {
                    echo '<li>' . htmlspecialchars($file) . '</li>';
                }
            }
            
            echo '</ul>
        </div>
    </body>
    </html>';
    exit;
}

// PDF-Header setzen
header('Content-Type: application/pdf');
header('Content-Disposition: inline; filename="' . $filename . '"');
header('Cache-Control: private, max-age=0, must-revalidate');
header('Pragma: public');
header('Content-Length: ' . filesize($filepath));

readfile($filepath);
?>
