<?php
/**
 * Test-E-Mail für Verifikation senden
 * 
 * Debug-Tool zum Testen des E-Mail-Versands bei Freischaltung/Ablehnung
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Logging aktivieren
$logFile = __DIR__ . '/../logs/email_test_' . date('Y-m-d_H-i-s') . '.log';
$logDir = dirname($logFile);
if (!is_dir($logDir)) {
    mkdir($logDir, 0755, true);
}

function writeLog($message, $level = 'INFO') {
    global $logFile;
    $timestamp = date('Y-m-d H:i:s');
    file_put_contents($logFile, "[$timestamp] [$level] $message\n", FILE_APPEND);
}

writeLog("=== E-Mail Test gestartet ===");

try {
    writeLog("1. Lade Konfiguration...");
    require_once __DIR__ . '/config.php';
    
    writeLog("2. Prüfe Autohaus-SMTP-Daten...");
    $stmt = $pdo->prepare("SELECT id, name, email_smtp_host, email_smtp_port, email_smtp_username, email_smtp_password, email_smtp_encryption, email_from_name, is_active FROM autohaus WHERE is_active = 1 ORDER BY id LIMIT 5");
    $stmt->execute();
    $autohauses = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    writeLog("3. Gefundene Autohäuser: " . count($autohauses));
    
    foreach ($autohauses as $autohaus) {
        writeLog("--- Autohaus: {$autohaus['name']} (ID: {$autohaus['id']}) ---");
        writeLog("  Active: " . ($autohaus['is_active'] ? 'Ja' : 'Nein'));
        writeLog("  SMTP Host: " . ($autohaus['email_smtp_host'] ?: 'NICHT GESETZT'));
        writeLog("  SMTP Port: " . ($autohaus['email_smtp_port'] ?: 'NICHT GESETZT'));
        writeLog("  SMTP Username: " . ($autohaus['email_smtp_username'] ?: 'NICHT GESETZT'));
        writeLog("  SMTP Password: " . ($autohaus['email_smtp_password'] ? 'GESETZT' : 'NICHT GESETZT'));
        writeLog("  SMTP Encryption: " . ($autohaus['email_smtp_encryption'] ?: 'NICHT GESETZT'));
        writeLog("  From Name: " . ($autohaus['email_from_name'] ?: 'NICHT GESETZT'));
        writeLog("");
    }
    
    // Verwende das erste Autohaus mit konfigurierten SMTP-Daten
    $autohaus = null;
    foreach ($autohauses as $ah) {
        if (!empty($ah['email_smtp_host'])) {
            $autohaus = $ah;
            writeLog("4. Verwende Autohaus: {$autohaus['name']} für E-Mail-Versand");
            break;
        }
    }
    
    if (!$autohaus) {
        writeLog("FEHLER: Kein Autohaus mit konfigurierten SMTP-Daten gefunden!");
        writeLog("=== Test beendet mit Fehler ===");
        die("FEHLER: Kein Autohaus mit konfigurierten SMTP-Daten gefunden!");
    }
    
    writeLog("5. Teste PHPMailer-Installation...");
    if (class_exists('PHPMailer\\PHPMailer\\PHPMailer')) {
        writeLog("  ✓ PHPMailer ist verfügbar");
    } else {
        writeLog("  ✗ PHPMailer ist NICHT verfügbar");
        writeLog("  Versuche PHPMailer zu laden...");
        
        // Verwende vendor-Version (richtige PHPMailer-Implementierung mit Office 365 Fix)
        if (file_exists(__DIR__ . '/../vendor/phpmailer/PHPMailer.php')) {
            require_once __DIR__ . '/../vendor/phpmailer/PHPMailer.php';
            require_once __DIR__ . '/../vendor/phpmailer/SMTP.php';
            require_once __DIR__ . '/../vendor/phpmailer/Exception.php';
            writeLog("  ✓ PHPMailer geladen (vendor)");
        } else {
            require_once __DIR__ . '/phpmailer/PHPMailer.php';
            require_once __DIR__ . '/phpmailer/SMTP.php';
            require_once __DIR__ . '/phpmailer/Exception.php';
            writeLog("  ✓ PHPMailer geladen (custom)");
        }
    }
    
    writeLog("6. Erstelle Test-E-Mail...");
    $testEmail = $_GET['email'] ?? 'test@example.com';
    $subject = "Test-E-Mail - Boxenstop Verifikation";
    
    $message = "
        <!DOCTYPE html>
        <html>
        <head>
            <meta charset='UTF-8'>
            <style>
                body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
                .container { max-width: 600px; margin: 0 auto; padding: 20px; }
                .header { background: linear-gradient(135deg, #0056b3 0%, #003057 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }
                .content { background: #f8f9fa; padding: 30px; border-radius: 0 0 10px 10px; }
                .info-box { background: #fff3cd; border-left: 4px solid #ffc107; padding: 15px; margin: 20px 0; border-radius: 8px; }
            </style>
        </head>
        <body>
            <div class='container'>
                <div class='header'>
                    <h1>🧪 Test-E-Mail</h1>
                </div>
                <div class='content'>
                    <h2>Hallo,</h2>
                    <p>Dies ist eine Test-E-Mail für die Boxenstop Verifikation.</p>
                    
                    <div class='info-box'>
                        <strong>SMTP-Daten verwendet:</strong>
                        <ul>
                            <li>Host: {$autohaus['email_smtp_host']}</li>
                            <li>Port: {$autohaus['email_smtp_port']}</li>
                            <li>Username: {$autohaus['email_smtp_username']}</li>
                            <li>From Name: {$autohaus['email_from_name']}</li>
                        </ul>
                    </div>
                    
                    <p><strong>✅ Wenn Sie diese E-Mail erhalten haben, funktioniert der E-Mail-Versand!</strong></p>
                </div>
            </div>
        </body>
        </html>
    ";
    
    writeLog("7. Starte PHPMailer...");
    $mail = new PHPMailer\PHPMailer\PHPMailer(true);
    
    try {
        writeLog("8. Konfiguriere SMTP...");
        $mail->isSMTP();
        $mail->Host = $autohaus['email_smtp_host'];
        $mail->SMTPAuth = true;
        $mail->Username = $autohaus['email_smtp_username'];
        $mail->Password = $autohaus['email_smtp_password'];
        $mail->SMTPSecure = 'tls'; // Fest auf TLS setzen für Outlook
        $mail->Port = 587; // Port 587 für STARTTLS
        $mail->CharSet = 'UTF-8';
        $mail->SMTPDebug = 2; // Zeigt alle SMTP-Kommandos
        
        // Debug-Output auch ins Log schreiben
        $mail->Debugoutput = function($str, $level) {
            writeLog("SMTP Debug: $str", 'DEBUG');
        };
        
        writeLog("9. SMTP-Optionen setzen...");
        // Outlook-SMTP erfordert spezielle Konfiguration
        // Keine SMTPOptions für TLS notwendig
        
        writeLog("10. Setze Absender...");
        $mail->setFrom($autohaus['email_smtp_username'], $autohaus['email_from_name'] ?? 'Boxenstop');
        
        writeLog("11. Setze Empfänger: $testEmail");
        $mail->addAddress($testEmail);
        
        writeLog("12. Setze E-Mail-Inhalt...");
        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body = $message;
        
        writeLog("13. Versuche E-Mail zu senden...");
        $result = $mail->send();
        
        if ($result) {
            writeLog("✅ ERFOLG: E-Mail wurde erfolgreich gesendet an: $testEmail");
            echo "✅ ERFOLG: E-Mail wurde erfolgreich gesendet an: $testEmail";
            echo "<br><br>";
            echo "<strong>Log-Datei:</strong> $logFile";
        } else {
            writeLog("✗ FEHLER: E-Mail konnte nicht gesendet werden");
            echo "✗ FEHLER: E-Mail konnte nicht gesendet werden";
        }
        
    } catch (Exception $e) {
        writeLog("✗ FEHLER: " . $e->getMessage(), 'ERROR');
        echo "✗ FEHLER: " . $e->getMessage();
        echo "<br><br>";
        echo "<strong>Log-Datei:</strong> $logFile";
    }
    
    writeLog("=== Test beendet ===");
    
} catch (Exception $e) {
    writeLog("KRITISCHER FEHLER: " . $e->getMessage(), 'ERROR');
    echo "KRITISCHER FEHLER: " . $e->getMessage();
    echo "<br><br>";
    echo "<strong>Log-Datei:</strong> $logFile";
}
?>

