<?php
/**
 * Email-Versand für Wheelset-Angebote
 */

function sendWheelsetOfferEmail($offer, $autohaus, $recipientEmail, $token) {
    require_once dirname(__DIR__) . '/config/database.php';
    
    // Prüfe ob SMTP-Konfiguration vorhanden ist (wie in admin_approve_user.php)
    if (empty($autohaus['email_smtp_host']) || empty($autohaus['email_smtp_password'])) {
        return [
            'success' => false,
            'error' => 'SMTP-Konfiguration fehlt. Bitte konfigurieren Sie die SMTP-Einstellungen für das Autohaus in den Einstellungen.'
        ];
    }
    
    try {
        // PHPMailer laden - verwende gleiche Logik wie admin_approve_user.php
        // Verwende vendor-Version (richtige PHPMailer-Implementierung)
        if (file_exists(dirname(__DIR__) . '/vendor/phpmailer/PHPMailer.php')) {
            require_once dirname(__DIR__) . '/vendor/phpmailer/PHPMailer.php';
            require_once dirname(__DIR__) . '/vendor/phpmailer/SMTP.php';
            require_once dirname(__DIR__) . '/vendor/phpmailer/Exception.php';
        } else if (file_exists(dirname(__DIR__) . '/vendor/autoload.php')) {
            require_once dirname(__DIR__) . '/vendor/autoload.php';
        } else {
            require_once dirname(__DIR__) . '/api/phpmailer/PHPMailer.php';
            require_once dirname(__DIR__) . '/api/phpmailer/SMTP.php';
            require_once dirname(__DIR__) . '/api/phpmailer/Exception.php';
        }
        
        // PHPMailer instanziieren - prüfe Namespace (wie in admin_approve_user.php)
        $mail = new \PHPMailer\PHPMailer\PHPMailer(true);
        
        // SMTP-Konfiguration aus Autohaus-Daten (wie in admin_approve_user.php)
        $mail->isSMTP();
        $mail->Host = $autohaus['email_smtp_host'];
        $mail->SMTPAuth = true;
        $mail->Username = $autohaus['email_smtp_username'];
        $mail->Password = $autohaus['email_smtp_password'];
        // WICHTIG: TLS ERFORDERLICH für Office 365 auf Port 587!
        $mail->SMTPSecure = \PHPMailer\PHPMailer\PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port = $autohaus['email_smtp_port'] ?? 587;
        $mail->CharSet = 'UTF-8';
        $mail->SMTPDebug = 0;
        
        // Recipients - use SMTP username as sender
        $mail->setFrom($autohaus['email_smtp_username'], $autohaus['email_from_name'] ?? ($autohaus['name'] ?? 'B&E Gruppe'));
        $mail->addAddress($recipientEmail);
        
        // Add reply-to header
        $mail->addReplyTo($autohaus['email_smtp_username'], $autohaus['email_from_name'] ?? ($autohaus['name'] ?? 'B&E Gruppe'));
        
        // Content
        $mail->isHTML(true);
        $mail->Subject = 'Reifenangebot - ' . ($offer['license_plate'] ?? 'Ihr Fahrzeug');
        $mail->Body = generateWheelsetOfferEmailBody($offer, $autohaus, $token);
        
        // Send email
        $mail->send();
        
        error_log("=== WHEELSET OFFER E-MAIL ERFOLGREICH ===");
        error_log("Empfänger: $recipientEmail");
        error_log("Autohaus: " . ($autohaus['name'] ?? 'Unbekannt'));
        error_log("SMTP Server: " . $autohaus['email_smtp_host'] . ":" . ($autohaus['email_smtp_port'] ?? 587));
        
        return [
            'success' => true,
            'message' => 'E-Mail erfolgreich versendet'
        ];
        
    } catch (\Exception $e) {
        error_log("=== WHEELSET OFFER E-MAIL FEHLER ===");
        error_log("Empfänger: $recipientEmail");
        error_log("Autohaus: " . ($autohaus['name'] ?? 'Unbekannt'));
        error_log("Fehler: " . $e->getMessage());
        error_log("SMTP Server: " . ($autohaus['email_smtp_host'] ?? 'NICHT GESETZT') . ":" . ($autohaus['email_smtp_port'] ?? 587));
        error_log("Username: " . ($autohaus['email_smtp_username'] ?? 'NICHT GESETZT'));
        
        return [
            'success' => false,
            'error' => 'E-Mail konnte nicht versendet werden: ' . $e->getMessage()
        ];
    }
}

function generateWheelsetOfferEmailBody($offer, $autohaus, $token) {
    $baseUrl = getBaseUrl();
    $selectionUrl = $baseUrl . '/wheelset_offer_selection.php?token=' . $token;
    
    $offerData = json_decode($offer['offer_data'], true);
    $newTires = $offerData['new_tires'] ?? [];
    
    // Bereite Reifenliste vor
    $tiresList = '';
    if (!empty($newTires)) {
        foreach ($newTires as $tire) {
            $tiresList .= '<tr><td style="padding: 8px 0; border-bottom: 1px solid #e9ecef;">' . 
                         htmlspecialchars($tire['brand_model'] ?? '') . 
                         ' (' . htmlspecialchars($tire['dimension'] ?? '') . ')</td>' .
                         '<td style="padding: 8px 0; border-bottom: 1px solid #e9ecef; text-align: right; font-weight: 600;">' . 
                         number_format($tire['total'] ?? 0, 2, ',', '.') . ' €</td></tr>';
        }
    }
    
    // E-Mail-Client-kompatible HTML mit Tabellen-Layout und Inline-CSS
    return '
    <!DOCTYPE html>
    <html lang="de">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Reifenangebot</title>
    </head>
    <body style="margin: 0; padding: 0; background-color: #f5f5f5; font-family: Arial, Helvetica, sans-serif; font-size: 16px; line-height: 1.6; color: #333333;">
        <table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color: #f5f5f5; padding: 20px;">
            <tr>
                <td align="center">
                    <table width="600" cellpadding="0" cellspacing="0" border="0" style="max-width: 600px; background-color: #ffffff; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                        <!-- Header -->
                        <tr>
                            <td style="background-color: #667eea; padding: 40px 30px; text-align: center;">
                                <table width="100%" cellpadding="0" cellspacing="0" border="0">
                                    <tr>
                                        <td style="text-align: center; color: #ffffff; font-size: 32px; font-weight: bold; padding-bottom: 10px;">
                                            Reifenangebot
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="text-align: center; color: #ffffff; font-size: 14px; padding-top: 5px;">
                                            Professioneller Service für Ihr Fahrzeug
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        
                        <!-- Content -->
                        <tr>
                            <td style="padding: 30px;">
                                <p style="margin: 0 0 20px 0; color: #333333; font-size: 16px;">
                                    <strong>Sehr geehrte Damen und Herren,</strong>
                                </p>
                                
                                <p style="margin: 0 0 20px 0; color: #333333; font-size: 16px;">
                                    anbei erhalten Sie Ihr Reifenangebot für den kommenden Boxenstop.
                                </p>
                                
                                <!-- Preis-Hinweis -->
                                <table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color: #fff3cd; border: 2px solid #ffc107; border-radius: 6px; margin: 20px 0;">
                                    <tr>
                                        <td style="padding: 15px;">
                                            <p style="margin: 0; color: #856404; font-size: 14px; font-weight: bold;">
                                                WICHTIGER HINWEIS ZUM PREIS:
                                            </p>
                                            <p style="margin: 10px 0 0 0; color: #856404; font-size: 13px; line-height: 1.5;">
                                                Die angegebenen Reifenpreise gelten für 2 Wochen ab Angebotsdatum. Der Endpreis kann je nach Marktpreisen variieren. Zusätzliche Arbeiten können weitere Kosten verursachen.
                                            </p>
                                        </td>
                                    </tr>
                                </table>
                                
                                <!-- Angebots-Info -->
                                <table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color: #f8f9fa; border-left: 4px solid #667eea; border-radius: 4px; margin: 20px 0;">
                                    <tr>
                                        <td style="padding: 20px;">
                                            <p style="margin: 0 0 10px 0; color: #333333; font-size: 16px; font-weight: bold;">
                                                Ihr Reifenangebot
                                            </p>
                                            <p style="margin: 0; color: #666666; font-size: 14px;">
                                                Kennzeichen: <strong>' . htmlspecialchars($offer['license_plate'] ?? '') . '</strong><br>
                                                Satznummer: <strong>' . htmlspecialchars($offer['wheelset_number'] ?? '') . '</strong>
                                            </p>
                                        </td>
                                    </tr>
                                </table>
                                
                                ' . (!empty($tiresList) ? '
                                <!-- Reifen-Liste -->
                                <table width="100%" cellpadding="0" cellspacing="0" border="0" style="margin: 20px 0;">
                                    <tr>
                                        <td style="padding-bottom: 10px;">
                                            <p style="margin: 0; color: #333333; font-size: 16px; font-weight: bold;">
                                                Empfohlene Reifen:
                                            </p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color: #f8f9fa; border-radius: 4px;">
                                                ' . $tiresList . '
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                                ' : '') . '
                                
                                <!-- Anweisungen -->
                                <table width="100%" cellpadding="0" cellspacing="0" border="0" style="margin: 30px 0;">
                                    <tr>
                                        <td style="padding-bottom: 15px;">
                                            <p style="margin: 0; color: #333333; font-size: 18px; font-weight: bold;">
                                                Kundenauswahl
                                            </p>
                                            <p style="margin: 10px 0 0 0; color: #666666; font-size: 14px;">
                                                Bitte wählen Sie aus den folgenden Optionen aus:
                                            </p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 15px 0;">
                                            <table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color: #f8f9fa; border-radius: 4px; margin-bottom: 10px;">
                                                <tr>
                                                    <td style="padding: 15px;">
                                                        <p style="margin: 0 0 5px 0; color: #333333; font-size: 14px; font-weight: bold;">
                                                            Reifen auswählen
                                                        </p>
                                                        <p style="margin: 0; color: #666666; font-size: 13px;">
                                                            Klicken Sie auf die gewünschten Reifen, um Ihre Auswahl zu treffen.
                                                        </p>
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 15px 0;">
                                            <table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color: #f8f9fa; border-radius: 4px; margin-bottom: 10px;">
                                                <tr>
                                                    <td style="padding: 15px;">
                                                        <p style="margin: 0 0 5px 0; color: #333333; font-size: 14px; font-weight: bold;">
                                                            Zusatzleistungen auswählen
                                                        </p>
                                                        <p style="margin: 0; color: #666666; font-size: 13px;">
                                                            Wählen Sie die gewünschten Zusatzleistungen aus.
                                                        </p>
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 15px 0;">
                                            <table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color: #f8f9fa; border-radius: 4px;">
                                                <tr>
                                                    <td style="padding: 15px;">
                                                        <p style="margin: 0 0 5px 0; color: #333333; font-size: 14px; font-weight: bold;">
                                                            Anmerkungen hinzufügen
                                                        </p>
                                                        <p style="margin: 0; color: #666666; font-size: 13px;">
                                                            Fügen Sie optional besondere Wünsche oder Anmerkungen hinzu.
                                                        </p>
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                                
                                <!-- CTA Button -->
                                <table width="100%" cellpadding="0" cellspacing="0" border="0" style="margin: 30px 0;">
                                    <tr>
                                        <td align="center" style="padding: 20px 0;">
                                            <table cellpadding="0" cellspacing="0" border="0">
                                                <tr>
                                                    <td style="background-color: #667eea; border-radius: 6px; padding: 16px 32px;">
                                                        <a href="' . htmlspecialchars($selectionUrl) . '" style="color: #ffffff; text-decoration: none; font-size: 16px; font-weight: bold; display: inline-block;">
                                                            Auswahl treffen
                                                        </a>
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td align="center" style="padding: 10px 0;">
                                            <p style="margin: 0; color: #666666; font-size: 13px;">
                                                Falls der Button nicht angezeigt wird, kopieren Sie bitte diesen Link:<br>
                                                <a href="' . htmlspecialchars($selectionUrl) . '" style="color: #667eea; text-decoration: underline; word-break: break-all;">' . htmlspecialchars($selectionUrl) . '</a>
                                            </p>
                                        </td>
                                    </tr>
                                </table>
                                
                                <!-- Link-Hinweis -->
                                <table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color: #fff3cd; border: 1px solid #ffc107; border-radius: 4px; margin: 20px 0;">
                                    <tr>
                                        <td style="padding: 15px;">
                                            <p style="margin: 0; color: #856404; font-size: 14px; font-weight: bold;">
                                                Wichtiger Hinweis:
                                            </p>
                                            <p style="margin: 10px 0 0 0; color: #856404; font-size: 13px; line-height: 1.5;">
                                                Der Link ist 24 Stunden gültig. Ihre Auswahl wird automatisch an uns übermittelt und Sie erhalten eine Bestätigung.
                                            </p>
                                        </td>
                                    </tr>
                                </table>
                                
                                <p style="margin: 20px 0 0 0; color: #333333; font-size: 16px;">
                                    Bei Fragen stehen wir Ihnen gerne zur Verfügung.
                                </p>
                            </td>
                        </tr>
                        
                        <!-- Footer -->
                        <tr>
                            <td style="background-color: #f8f9fa; padding: 30px; text-align: center; border-top: 1px solid #dee2e6;">
                                <p style="margin: 0 0 10px 0; color: #333333; font-size: 16px; font-weight: bold;">
                                    Mit freundlichen Grüßen
                                </p>
                                <p style="margin: 0 0 5px 0; color: #667eea; font-size: 18px; font-weight: bold;">
                                    ' . htmlspecialchars($offer['employee_name'] ?? ($autohaus['email_from_name'] ?? $autohaus['name'])) . '
                                </p>
                                <p style="margin: 0; color: #333333; font-size: 14px;">
                                    ' . htmlspecialchars($autohaus['name']) . '
                                </p>
                                <p style="margin: 20px 0 0 0; color: #999999; font-size: 12px; line-height: 1.5;">
                                    Diese E-Mail wurde automatisch generiert. Bitte antworten Sie nicht direkt auf diese E-Mail.
                                </p>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </body>
    </html>';
}

function getBaseUrl() {
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https://' : 'http://';
    $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
    $scriptName = dirname($_SERVER['SCRIPT_NAME'] ?? '');
    
    // Wenn wir in api/ sind, gehen wir eine Ebene höher
    if (strpos($scriptName, '/api') !== false) {
        $scriptName = dirname($scriptName);
    }
    
    return $protocol . $host . $scriptName;
}

