<?php
/**
 * Save User Session - Speichert User-Session nach erfolgreichem Login
 */
session_start();
require_once 'config.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input || !isset($input['user']) || !isset($input['token'])) {
        throw new Exception('Invalid input');
    }
    
    $user = $input['user'];
    $token = $input['token'];
    
    // Prüfe ob Token gültig ist
    $stmt = $pdo->prepare("SELECT id FROM users WHERE auth_token = ? AND is_active = 1 AND token_expires_at > NOW()");
    $stmt->execute([$token]);
    $validUser = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$validUser || $validUser['id'] != $user['id']) {
        throw new Exception('Invalid token');
    }
    
    // Session-ID regenerieren für Sicherheit (verhindert Session Fixation)
    session_regenerate_id(true);
    
    // Session speichern
    $_SESSION['user_logged_in'] = true;
    $_SESSION['user_id'] = $user['id'];
    $_SESSION['user_email'] = $user['email'];
    $_SESSION['user_name'] = $user['first_name'] . ' ' . $user['last_name'];
    $_SESSION['user_token'] = $token;
    
    // Optional: Device info speichern
    $_SESSION['user_device'] = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
    
    echo json_encode([
        'success' => true,
        'message' => 'Session saved successfully',
        'user_id' => $user['id']
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>

