<?php
/**
 * RESY-Integration mit Puppeteer (echter Browser)
 * Nutzt echten Chrome-Browser für RESY-Login
 */

class ResyPuppeteerDriver {
    private $username;
    private $password;
    private $dealerId;
    
    public function __construct($username, $password, $dealerId) {
        $this->username = $username;
        $this->password = $password;
        $this->dealerId = $dealerId;
    }
    
    /**
     * Führt Login durch mit echtem Browser
     */
    public function loginAndFetch() {
        try {
            error_log("Starte Puppeteer für RESY-Login...");
            
            // Erstelle temporäres JavaScript-File
            $jsFile = __DIR__ . '/../temp/resy_puppeteer_' . time() . '.js';
            $this->createPuppeteerScript($jsFile);
            
            // Führe mit Node.js aus
            $command = "node \"$jsFile\" 2>&1";
            $output = shell_exec($command);
            
            error_log("Puppeteer Output: " . substr($output, 0, 500));
            
            // Lösche temporäres File
            @unlink($jsFile);
            
            // Parse Output
            $result = json_decode($output, true);
            
            error_log("Puppeteer result: " . print_r($result, true));
            
            if ($result && isset($result['success']) && $result['success']) {
                $count = $result['count'] ?? 0;
                error_log("✅ Puppeteer erfolgreich - $count Reifensätze gefunden");
                return $result['wheelsets'] ?? [];
            } else {
                $error = $result['error'] ?? 'Unbekannt';
                error_log("❌ Puppeteer-Fehler: $error");
                error_log("Vollständiger Output: " . $output);
                return [];
            }
            
        } catch (Exception $e) {
            error_log("Puppeteer-Fehler: " . $e->getMessage());
            return [];
        }
    }
    
    /**
     * Erstellt Puppeteer-Script
     */
    private function createPuppeteerScript($filePath) {
        $script = <<<'JS'
const puppeteer = require('puppeteer');

(async () => {
    const browser = await puppeteer.launch({
        headless: 'new',
        args: ['--no-sandbox', '--disable-setuid-sandbox']
    });
    
    const page = await browser.newPage();
    
    try {
        // 1. Login-Seite öffnen
        await page.goto('https://resy.dtm-reifen.de/index.php?m=login&a=login', {
            waitUntil: 'networkidle2',
            timeout: 30000
        });
        
        // 2. Warte auf Login-Felder
        await page.waitForSelector('#InputUser', { timeout: 10000 });
        
        // 3. Fülle Login-Felder
        await page.type('#InputUser', 'USERNAME_PLACEHOLDER');
        await page.type('#InputPass', 'PASSWORD_PLACEHOLDER');
        
        // 4. Versuche Login-Button zu finden und klicken
        const buttonSelector = 'input[type="submit"], button[type="submit"], input[name="button"], button';
        await page.waitForSelector(buttonSelector, { timeout: 5000 });
        
        // 5. Submit form statt auf Navigation zu warten
        await Promise.all([
            page.click(buttonSelector),
            page.waitForNavigation({ waitUntil: 'networkidle0', timeout: 30000 })
        ]);
        
        console.log("✅ Login erfolgreich");
        
        // 6. Navigiere zur Reifensatz-Suche
        const searchUrl = 'https://resy.dtm-reifen.de/index.php?m=wheelset&a=search&FN=WheelsetSearch&KD_ID=DEALER_ID_PLACEHOLDER&STATUS_ID=20';
        await page.goto(searchUrl, { waitUntil: 'networkidle2', timeout: 30000 });
        
        // 7. Hole HTML
        const html = await page.content();
        
        // 8. Extrahiere Daten
        const wheelsets = await page.evaluate(() => {
            const rows = document.querySelectorAll('table tr');
            const data = [];
            
            rows.forEach(row => {
                const cells = row.querySelectorAll('td');
                if (cells.length >= 5) {
                    data.push({
                        kennzeichen: cells[0]?.textContent?.trim() || '',
                        satznummer: cells[1]?.textContent?.trim() || '',
                        eingangsdatum: cells[2]?.textContent?.trim() || '',
                        fahrzeugtyp: cells[3]?.textContent?.trim() || '',
                        status: cells[4]?.textContent?.trim() || ''
                    });
                }
            });
            
            return data.filter(item => item.kennzeichen.length >= 3);
        });
        
        await browser.close();
        
        console.log(JSON.stringify({
            success: true,
            count: wheelsets.length,
            wheelsets: wheelsets,
            html: html
        }));
        
    } catch (error) {
        await browser.close();
        console.log(JSON.stringify({
            success: false,
            error: error.message
        }));
    }
})();

JS;
        
        // Ersetze Platzhalter
        $script = str_replace('USERNAME_PLACEHOLDER', $this->username, $script);
        $script = str_replace('PASSWORD_PLACEHOLDER', $this->password, $script);
        $script = str_replace('DEALER_ID_PLACEHOLDER', $this->dealerId, $script);
        
        file_put_contents($filePath, $script);
    }
    
    /**
     * Prüft ob Puppeteer verfügbar ist
     */
    public static function isAvailable() {
        $result = shell_exec('node -v 2>&1');
        $npmResult = shell_exec('npm list puppeteer 2>&1');
        
        return !empty($result) && strpos($npmResult, 'puppeteer') !== false;
    }
}

