<?php
/**
 * Importiert RESY HTML-Daten
 */

header('Content-Type: application/json');

require_once dirname(__DIR__) . '/config/database.php';

try {
    if (!isset($_FILES['html']) || $_FILES['html']['error'] !== UPLOAD_ERR_OK) {
        throw new Exception("Keine Datei hochgeladen");
    }
    
    $html = file_get_contents($_FILES['html']['tmp_name']);
    $autohausId = $_POST['autohaus_id'] ?? 1;
    
    // Parse HTML
    $db = new Database();
    $pdo = $db->getConnection();
    
    libxml_use_internal_errors(true);
    $dom = new DOMDocument();
    $dom->loadHTML($html);
    $xpath = new DOMXPath($dom);
    
    // Finde alle Reifensätze
    $rows = $xpath->query('//tr');
    $wheelsets = [];
    
    error_log("Import: Analysiere " . $rows->length . " Zeilen");
    
    foreach ($rows as $row) {
        $cells = $xpath->query('./td', $row);
        
        // Mehr Flexibilität: Auch mit weniger Spalten
        if ($cells->length >= 2) {
            $kennzeichen = trim($cells->item(0)->textContent ?? '');
            $satznummer = trim($cells->item(1)->textContent ?? '');
            
            // Prüfe ob Kennzeichen aussieht (mindestens 2 Zeichen)
            if (strlen($kennzeichen) >= 2 && strlen($kennzeichen) <= 20) {
                // Extrahiere weitere Felder wenn vorhanden
                $eingangsdatum = $cells->length >= 3 ? trim($cells->item(2)->textContent ?? '') : '';
                $fahrzeugtyp = $cells->length >= 4 ? trim($cells->item(3)->textContent ?? '') : '';
                $status = $cells->length >= 5 ? trim($cells->item(4)->textContent ?? '') : 'gelagert';
                
                $wheelsets[] = [
                    'kennzeichen' => $kennzeichen,
                    'satznummer' => $satznummer,
                    'eingangsdatum' => $eingangsdatum,
                    'fahrzeugtyp' => $fahrzeugtyp,
                    'marke' => 'RESY',
                    'modell' => $fahrzeugtyp ?: 'RESY',
                    'oe_nummer' => $satznummer,
                    'status' => $status
                ];
            }
        }
    }
    
    error_log("Import: " . count($wheelsets) . " Reifensätze extrahiert");
    
    // Speichere in Datenbank
    $count = 0;
    foreach ($wheelsets as $ws) {
        $stmt = $pdo->prepare("
            INSERT INTO stored_wheelsets 
            (autohaus_id, kennzeichen, marke, modell, oe_nummer, status, updated_at)
            VALUES (?, ?, ?, ?, ?, ?, NOW())
            ON DUPLICATE KEY UPDATE 
            updated_at = NOW()
        ");
        $stmt->execute([
            $autohausId,
            $ws['kennzeichen'],
            $ws['marke'],
            $ws['modell'],
            $ws['oe_nummer'],
            $ws['status']
        ]);
        $count++;
    }
    
    echo json_encode([
        'success' => true,
        'count' => $count,
        'message' => "$count Reifensätze importiert"
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
