<?php
/**
 * Fahrzeug abrufen
 */
session_start();
require_once 'config.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

try {
    // Prüfe ob User eingeloggt ist
    if (!isset($_SESSION['user_logged_in']) || !$_SESSION['user_logged_in']) {
        throw new Exception('Nicht angemeldet');
    }
    
    $user_id = $_SESSION['user_id'];
    $vehicle_id = $_GET['id'] ?? null;
    
    if (!$vehicle_id) {
        throw new Exception('Fahrzeug-ID erforderlich');
    }
    
    // Fahrzeug laden und prüfen ob es dem User gehört
    $stmt = $pdo->prepare("SELECT * FROM user_vehicles WHERE id = ? AND user_id = ? AND is_active = 1");
    $stmt->execute([$vehicle_id, $user_id]);
    $vehicle = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$vehicle) {
        throw new Exception('Fahrzeug nicht gefunden');
    }
    
    echo json_encode([
        'success' => true,
        'vehicle' => $vehicle
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>

