<?php
// get_user_status.php - Benutzerstatus abrufen
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

if ($_SERVER['REQUEST_METHOD'] !== 'GET' && $_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

require_once 'config.php';

try {
    // Token aus Header extrahieren
    $headers = getallheaders();
    $auth_header = $headers['Authorization'] ?? '';
    
    if (!preg_match('/Bearer\s+(.*)$/i', $auth_header, $matches)) {
        throw new Exception('Authorization token required');
    }
    
    $token = $matches[1];
    
    // Benutzer anhand Token finden
    $stmt = $pdo->prepare("SELECT * FROM users WHERE auth_token = ? AND is_active = 1 AND token_expires_at > NOW()");
    $stmt->execute([$token]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$user) {
        throw new Exception('Invalid or expired token');
    }
    
    // Passwort-Hash aus Antwort entfernen
    unset($user['password_hash']);
    
    // Dokument-Statistiken abrufen
    $stmt = $pdo->prepare("
        SELECT 
            COUNT(*) as document_count,
            SUM(CASE WHEN status = 'approved' THEN 1 ELSE 0 END) as approved_count,
            SUM(CASE WHEN status = 'rejected' THEN 1 ELSE 0 END) as rejected_count
        FROM verification_documents 
        WHERE user_id = ?
    ");
    $stmt->execute([$user['id']]);
    $document_stats = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Benachrichtigungs-Statistiken abrufen
    $stmt = $pdo->prepare("
        SELECT 
            COUNT(*) as total_notifications,
            SUM(CASE WHEN is_read = 0 THEN 1 ELSE 0 END) as unread_count
        FROM notifications 
        WHERE user_id = ?
    ");
    $stmt->execute([$user['id']]);
    $notification_stats = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Verifikationsdokumente abrufen
    $stmt = $pdo->prepare("
        SELECT 
            id, document_type, file_name, file_path, file_size, 
            mime_type, upload_date, status, admin_notes, 
            reviewed_by, reviewed_at
        FROM verification_documents 
        WHERE user_id = ? 
        ORDER BY upload_date DESC
    ");
    $stmt->execute([$user['id']]);
    $documents = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Benachrichtigungen abrufen
    $stmt = $pdo->prepare("
        SELECT 
            id, title, message, type, is_read, created_at
        FROM notifications 
        WHERE user_id = ? 
        ORDER BY created_at DESC 
        LIMIT 10
    ");
    $stmt->execute([$user['id']]);
    $notifications = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'user' => $user,
        'document_stats' => $document_stats,
        'notification_stats' => $notification_stats,
        'documents' => $documents,
        'notifications' => $notifications,
        'message' => 'User status retrieved successfully'
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>
