<?php
/**
 * Fahrzeug löschen (Soft Delete)
 */
session_start();
require_once 'config.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

try {
    // Prüfe ob User eingeloggt ist
    if (!isset($_SESSION['user_logged_in']) || !$_SESSION['user_logged_in']) {
        throw new Exception('Nicht angemeldet');
    }
    
    $user_id = $_SESSION['user_id'];
    
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input || empty($input['vehicle_id'])) {
        throw new Exception('Fahrzeug-ID erforderlich');
    }
    
    $vehicle_id = $input['vehicle_id'];
    
    // Prüfe ob Fahrzeug dem User gehört und nicht Standard ist
    $stmt = $pdo->prepare("SELECT id, is_default FROM user_vehicles WHERE id = ? AND user_id = ? AND is_active = 1");
    $stmt->execute([$vehicle_id, $user_id]);
    $vehicle = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$vehicle) {
        throw new Exception('Fahrzeug nicht gefunden');
    }
    
    if ($vehicle['is_default']) {
        throw new Exception('Das Standardfahrzeug kann nicht gelöscht werden. Setzen Sie zuerst ein anderes Fahrzeug als Standard.');
    }
    
    // Soft Delete
    $stmt = $pdo->prepare("UPDATE user_vehicles SET is_active = 0, updated_at = NOW() WHERE id = ? AND user_id = ?");
    $result = $stmt->execute([$vehicle_id, $user_id]);
    
    if ($result) {
        echo json_encode([
            'success' => true,
            'message' => 'Fahrzeug erfolgreich gelöscht'
        ]);
    } else {
        throw new Exception('Fehler beim Löschen des Fahrzeugs');
    }
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>

