<?php
/**
 * Autohaus-Auswahl API
 * Verwaltet die Auswahl des Autohauses für Kunden
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

session_start();
require_once dirname(__DIR__) . '/config/database.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input || !isset($input['action'])) {
        echo json_encode([
            'success' => false,
            'error' => 'Fehlende Parameter'
        ]);
        exit;
    }
    
    try {
        $db = new Database();
        $conn = $db->getConnection();
        
        if ($input['action'] === 'select_autohaus') {
            if (!isset($input['autohaus_id']) || !isset($input['autohaus_name'])) {
                echo json_encode([
                    'success' => false,
                    'error' => 'Autohaus-ID und Name erforderlich'
                ]);
                exit;
            }
            
            // Prüfe ob Autohaus existiert und aktiv ist
            $stmt = $conn->prepare("SELECT * FROM autohaus WHERE id = ? AND is_active = 1");
            $stmt->execute([$input['autohaus_id']]);
            $autohaus = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if (!$autohaus) {
                echo json_encode([
                    'success' => false,
                    'error' => 'Autohaus nicht gefunden oder inaktiv'
                ]);
                exit;
            }
            
            // Autohaus in Session speichern
            $_SESSION['selected_autohaus_id'] = $input['autohaus_id'];
            $_SESSION['selected_autohaus_name'] = $input['autohaus_name'];
            
            echo json_encode([
                'success' => true,
                'message' => 'Autohaus erfolgreich ausgewählt',
                'autohaus_id' => $input['autohaus_id'],
                'autohaus_name' => $input['autohaus_name']
            ]);
            
        } elseif ($input['action'] === 'get_selected_autohaus') {
            // Aktuell ausgewähltes Autohaus abrufen
            $autohausId = $_SESSION['selected_autohaus_id'] ?? null;
            $autohausName = $_SESSION['selected_autohaus_name'] ?? null;
            
            if ($autohausId) {
                echo json_encode([
                    'success' => true,
                    'autohaus_id' => $autohausId,
                    'autohaus_name' => $autohausName
                ]);
            } else {
                echo json_encode([
                    'success' => false,
                    'message' => 'Kein Autohaus ausgewählt'
                ]);
            }
            
        } elseif ($input['action'] === 'clear_autohaus') {
            // Autohaus-Auswahl zurücksetzen
            unset($_SESSION['selected_autohaus_id']);
            unset($_SESSION['selected_autohaus_name']);
            
            echo json_encode([
                'success' => true,
                'message' => 'Autohaus-Auswahl zurückgesetzt'
            ]);
            
        } else {
            echo json_encode([
                'success' => false,
                'error' => 'Unbekannte Aktion'
            ]);
        }
        
    } catch (Exception $e) {
        echo json_encode([
            'success' => false,
            'error' => 'Fehler: ' . $e->getMessage()
        ]);
    }
    
} else {
    echo json_encode([
        'success' => false,
        'error' => 'Nur POST-Requests erlaubt'
    ]);
}
?>
