<?php
// Analysiere die gespeicherte HTML-Antwort
$htmlFile = sys_get_temp_dir() . '/resy_wheelsets_response_1.html';

if (file_exists($htmlFile)) {
    $html = file_get_contents($htmlFile);
    echo "HTML-Datei gefunden: " . strlen($html) . " bytes\n";
    
    // Suche nach Tabellen
    if (preg_match_all('/<table[^>]*>(.*?)<\/table>/s', $html, $tables)) {
        echo "Gefundene Tabellen: " . count($tables[1]) . "\n";
        
        foreach ($tables[1] as $index => $table) {
            echo "\n--- Tabelle " . ($index + 1) . " ---\n";
            echo "Länge: " . strlen($table) . " Zeichen\n";
            
            // Suche nach tbody
            if (preg_match_all('/<tbody[^>]*>(.*?)<\/tbody>/s', $table, $tbodies)) {
                echo "Gefundene tbody: " . count($tbodies[1]) . "\n";
                
                foreach ($tbodies[1] as $tbodyIndex => $tbody) {
                    echo "\n--- tbody " . ($tbodyIndex + 1) . " ---\n";
                    echo "Länge: " . strlen($tbody) . " Zeichen\n";
                    
                    if (preg_match_all('/<tr[^>]*>(.*?)<\/tr>/s', $tbody, $rows)) {
                        echo "Gefundene Zeilen: " . count($rows[1]) . "\n";
                        
                        foreach ($rows[1] as $rowIndex => $row) {
                            echo "\nZeile " . $rowIndex . ":\n";
                            echo "Länge: " . strlen($row) . " Zeichen\n";
                            
                            // Teste verschiedene Zellen-Patterns
                            $cellPatterns = [
                                '/<td[^>]*>(.*?)<\/td>/s',
                                '/<th[^>]*>(.*?)<\/th>/s',
                                '/<td[^>]*class="[^"]*"[^>]*>(.*?)<\/td>/s'
                            ];
                            
                            $cells = [];
                            foreach ($cellPatterns as $patternIndex => $pattern) {
                                if (preg_match_all($pattern, $row, $cellMatches)) {
                                    $cells = $cellMatches[1];
                                    echo "Zellen gefunden mit Pattern " . ($patternIndex + 1) . ": " . count($cells) . "\n";
                                    break;
                                }
                            }
                            
                            if (empty($cells)) {
                                echo "Keine Zellen gefunden\n";
                                echo "Row HTML (erste 200 Zeichen): " . substr($row, 0, 200) . "\n";
                            } else {
                                echo "Zellen-Inhalte:\n";
                                foreach ($cells as $cellIndex => $cell) {
                                    $cleanCell = trim(strip_tags($cell));
                                    echo "  Zelle $cellIndex: '" . $cleanCell . "'\n";
                                }
                            }
                            
                            if ($rowIndex >= 2) break; // Nur erste 3 Zeilen
                        }
                    }
                }
            } else {
                echo "Keine tbody gefunden\n";
                
                // Direkte Zeilen-Suche
                if (preg_match_all('/<tr[^>]*>(.*?)<\/tr>/s', $table, $rows)) {
                    echo "Gefundene Zeilen (direkt): " . count($rows[1]) . "\n";
                    
                    foreach ($rows[1] as $rowIndex => $row) {
                        echo "\nZeile " . $rowIndex . ":\n";
                        
                        if (preg_match_all('/<td[^>]*>(.*?)<\/td>/s', $row, $cells)) {
                            $cells = $cells[1];
                            echo "Zellen: " . count($cells) . "\n";
                            
                            foreach ($cells as $cellIndex => $cell) {
                                $cleanCell = trim(strip_tags($cell));
                                echo "  Zelle $cellIndex: '" . $cleanCell . "'\n";
                            }
                        }
                        
                        if ($rowIndex >= 2) break; // Nur erste 3 Zeilen
                    }
                }
            }
        }
    } else {
        echo "Keine Tabellen gefunden\n";
    }
} else {
    echo "HTML-Datei nicht gefunden: $htmlFile\n";
}
?>
