<?php
/**
 * 🚀 INTELLIGENT DASHBOARD SETUP
 * Einfaches Setup-Script für die Datenbank-Tabellen
 */

session_start();
require_once '../config/database_optimized.php';

// Check if user is logged in
if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    header('Location: login.php');
    exit;
}

$db = DatabaseOptimized::getInstance();
$conn = $db->getConnection();

$success_messages = [];
$error_messages = [];

// Execute SQL setup
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['setup_database'])) {
    try {
        $sql_file = '../database/setup_intelligent_dashboard.sql';
        if (!file_exists($sql_file)) {
            throw new Exception('SQL-Datei nicht gefunden: ' . $sql_file);
        }
        
        $sql = file_get_contents($sql_file);
        $statements = explode(';', $sql);
        
        foreach ($statements as $statement) {
            $statement = trim($statement);
            if (!empty($statement) && !preg_match('/^--/', $statement)) {
                $conn->exec($statement);
            }
        }
        
        $success_messages[] = '✅ Datenbank-Setup erfolgreich abgeschlossen!';
        $success_messages[] = '🚀 Alle Tabellen wurden erstellt und konfiguriert.';
        $success_messages[] = '🎯 Sie können jetzt das intelligente Dashboard verwenden!';
        
    } catch (Exception $e) {
        $error_messages[] = '❌ Fehler beim Setup: ' . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>🚀 Intelligent Dashboard Setup • Boxenstop</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    
    <style>
        :root {
            --primary: #6366f1;
            --secondary: #8b5cf6;
            --success: #10b981;
            --error: #ef4444;
            --gray-50: #f9fafb;
            --gray-100: #f3f4f6;
            --gray-800: #1f2937;
            --gray-900: #111827;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            color: var(--gray-800);
            line-height: 1.6;
        }

        .setup-container {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 2rem;
        }

        .setup-card {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 2rem;
            padding: 3rem;
            max-width: 600px;
            width: 100%;
            box-shadow: 0 25px 50px rgba(0, 0, 0, 0.25);
            text-align: center;
        }

        .setup-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            border-radius: 1rem;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
            color: white;
            margin: 0 auto 2rem;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
        }

        .setup-title {
            font-size: 2.5rem;
            font-weight: 800;
            color: white;
            margin-bottom: 1rem;
            letter-spacing: -0.02em;
        }

        .setup-description {
            color: rgba(255, 255, 255, 0.9);
            font-size: 1.1rem;
            margin-bottom: 2rem;
        }

        .setup-button {
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            color: white;
            border: none;
            border-radius: 1rem;
            padding: 1rem 2rem;
            font-size: 1.1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 0.5rem;
            margin: 0 auto;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
        }

        .setup-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.3);
        }

        .setup-button:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none;
        }

        .messages {
            margin-top: 2rem;
        }

        .message {
            padding: 1rem;
            border-radius: 0.75rem;
            margin-bottom: 1rem;
            font-weight: 500;
        }

        .message.success {
            background: rgba(16, 185, 129, 0.2);
            color: #10b981;
            border: 1px solid rgba(16, 185, 129, 0.3);
        }

        .message.error {
            background: rgba(239, 68, 68, 0.2);
            color: #ef4444;
            border: 1px solid rgba(239, 68, 68, 0.3);
        }

        .back-link {
            color: rgba(255, 255, 255, 0.8);
            text-decoration: none;
            margin-top: 2rem;
            display: inline-block;
            transition: color 0.3s ease;
        }

        .back-link:hover {
            color: white;
        }

        .features {
            text-align: left;
            margin: 2rem 0;
            color: rgba(255, 255, 255, 0.9);
        }

        .features h3 {
            color: white;
            margin-bottom: 1rem;
            font-size: 1.25rem;
        }

        .features ul {
            list-style: none;
            padding: 0;
        }

        .features li {
            padding: 0.5rem 0;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .features li::before {
            content: '✨';
            font-size: 1rem;
        }
    </style>
</head>
<body>
    <div class="setup-container">
        <div class="setup-card">
            <div class="setup-icon">
                <i class="fas fa-rocket"></i>
            </div>
            
            <h1 class="setup-title">🚀 Intelligent Dashboard Setup</h1>
            <p class="setup-description">
                Richten Sie Ihr intelligentes Dashboard-System ein und genießen Sie eine völlig neue Benutzererfahrung!
            </p>

            <div class="features">
                <h3>🎯 Was wird eingerichtet:</h3>
                <ul>
                    <li>Benutzer-Dashboard-Konfigurationen</li>
                    <li>KI-gestützte Empfehlungen</li>
                    <li>Individuelle Widget-Systeme</li>
                    <li>Schnellaktionen-Verwaltung</li>
                    <li>Performance-Tracking</li>
                    <li>Theme-System (Dark/Light)</li>
                </ul>
            </div>

            <?php if (!empty($success_messages)): ?>
                <div class="messages">
                    <?php foreach ($success_messages as $message): ?>
                        <div class="message success"><?php echo $message; ?></div>
                    <?php endforeach; ?>
                </div>
                <a href="index.php" class="back-link">
                    <i class="fas fa-arrow-left"></i>
                    Zum Dashboard
                </a>
            <?php elseif (!empty($error_messages)): ?>
                <div class="messages">
                    <?php foreach ($error_messages as $message): ?>
                        <div class="message error"><?php echo $message; ?></div>
                    <?php endforeach; ?>
                </div>
            <?php else: ?>
                <form method="POST">
                    <button type="submit" name="setup_database" class="setup-button">
                        <i class="fas fa-magic"></i>
                        Dashboard einrichten
                    </button>
                </form>
            <?php endif; ?>

            <a href="index.php" class="back-link">
                <i class="fas fa-home"></i>
                Zurück zum Dashboard
            </a>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const button = document.querySelector('.setup-button');
            if (button) {
                button.addEventListener('click', function() {
                    this.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Setup läuft...';
                    this.disabled = true;
                });
            }
        });
    </script>
</body>
</html>
