<?php
/**
 * Erstelle Test-Dokumente für User ID 10
 */

session_start();
require_once '../config/database.php';

// Simuliere Admin-Login
$_SESSION['admin_logged_in'] = true;
$_SESSION['admin_user_id'] = 1;

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    // Erstelle Test-Verzeichnis falls es nicht existiert
    $upload_dir = '../uploads/verification_documents/';
    if (!is_dir($upload_dir)) {
        mkdir($upload_dir, 0755, true);
    }
    
    // Erstelle eine einfache Test-Datei
    $test_file_path = $upload_dir . 'test_document.txt';
    if (!file_exists($test_file_path)) {
        file_put_contents($test_file_path, 'Dies ist ein Test-Dokument für die Verifikation.');
    }
    
    // Lösche alte Test-Dokumente
    $stmt = $conn->prepare("DELETE FROM verification_documents WHERE user_id = 10");
    $stmt->execute();
    
    // Füge Test-Dokumente hinzu
    $test_documents = [
        [
            'user_id' => 10,
            'document_type' => 'invoice',
            'file_name' => 'Rechnung_Test.pdf',
            'file_path' => $test_file_path,
            'file_size' => filesize($test_file_path),
            'mime_type' => 'text/plain',
            'review_status' => 'pending'
        ],
        [
            'user_id' => 10,
            'document_type' => 'id_card',
            'file_name' => 'Ausweis_Test.txt',
            'file_path' => $test_file_path,
            'file_size' => filesize($test_file_path),
            'mime_type' => 'text/plain',
            'review_status' => 'approved',
            'reviewed_by' => 1,
            'reviewed_at' => date('Y-m-d H:i:s'),
            'review_notes' => 'Test-Genehmigung'
        ]
    ];
    
    foreach ($test_documents as $doc) {
        $stmt = $conn->prepare("
            INSERT INTO verification_documents 
            (user_id, document_type, file_name, file_path, file_size, mime_type, review_status, reviewed_by, reviewed_at, review_notes)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        ");
        $stmt->execute([
            $doc['user_id'],
            $doc['document_type'],
            $doc['file_name'],
            $doc['file_path'],
            $doc['file_size'],
            $doc['mime_type'],
            $doc['review_status'],
            $doc['reviewed_by'] ?? null,
            $doc['reviewed_at'] ?? null,
            $doc['review_notes'] ?? null
        ]);
    }
    
    echo "✅ Test-Dokumente erfolgreich erstellt!<br>";
    echo "User ID 10 hat jetzt " . count($test_documents) . " Test-Dokumente.<br>";
    echo "<a href='admin_dashboard.php'>Zurück zum Admin-Dashboard</a>";
    
} catch (Exception $e) {
    echo "❌ Fehler: " . $e->getMessage();
}
?>
