<?php
/**
 * Cache Management Interface
 */

require_once '../config/database.php';
require_once '../api/cache_manager.php';

$cacheManager = new CacheManager($GLOBALS['conn']);

// Handle actions
if ($_POST['action'] ?? '' === 'clear_cache') {
    $autohausId = $_POST['autohaus_id'] ?? null;
    if ($autohausId) {
        $cacheManager->invalidateCache($autohausId);
        $message = "Cache für Autohaus $autohausId wurde geleert.";
    } else {
        // Clear all cache
        $cacheManager->cleanupExpiredCache();
        $message = "Alle abgelaufenen Cache-Einträge wurden bereinigt.";
    }
}

$cacheStats = $cacheManager->getCacheStats();
?>

<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cache Management - Boxenstop Admin</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/volvo-theme.css">
    <link rel="stylesheet" href="assets/css/admin.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="admin-body">
    <div class="admin-container">
        <div class="admin-header">
            <h1><i class="fas fa-database"></i> Cache Management</h1>
            <nav class="admin-nav">
                <a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a>
                <a href="storage.php"><i class="fas fa-warehouse"></i> Einlagerungen</a>
            </nav>
        </div>

        <div class="admin-content">
            <?php if (isset($message)): ?>
                <div class="alert alert-success">
                    <i class="fas fa-check-circle"></i> <?= htmlspecialchars($message) ?>
                </div>
            <?php endif; ?>

            <div class="card">
                <div class="card-header">
                    <h2><i class="fas fa-chart-bar"></i> Cache Statistiken</h2>
                </div>
                <div class="card-body">
                    <div class="stats-grid">
                        <div class="stat-card">
                            <div class="stat-icon">
                                <i class="fas fa-database"></i>
                            </div>
                            <div class="stat-content">
                                <div class="stat-number"><?= $cacheStats['total_entries'] ?? 0 ?></div>
                                <div class="stat-label">Gesamte Einträge</div>
                            </div>
                        </div>
                        
                        <div class="stat-card">
                            <div class="stat-icon">
                                <i class="fas fa-clock"></i>
                            </div>
                            <div class="stat-content">
                                <div class="stat-number"><?= $cacheStats['recent_entries'] ?? 0 ?></div>
                                <div class="stat-label">Aktuelle Einträge</div>
                            </div>
                        </div>
                        
                        <div class="stat-card">
                            <div class="stat-icon">
                                <i class="fas fa-calendar-alt"></i>
                            </div>
                            <div class="stat-content">
                                <div class="stat-number"><?= date('H:i', strtotime($cacheStats['newest_entry'] ?? 'now')) ?></div>
                                <div class="stat-label">Letzter Eintrag</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h2><i class="fas fa-tools"></i> Cache Aktionen</h2>
                </div>
                <div class="card-body">
                    <div class="action-buttons">
                        <button class="btn btn-warning" onclick="clearAllCache()">
                            <i class="fas fa-trash"></i>
                            Alle Caches leeren
                        </button>
                        
                        <button class="btn btn-info" onclick="cleanupCache()">
                            <i class="fas fa-broom"></i>
                            Abgelaufene Einträge bereinigen
                        </button>
                        
                        <button class="btn btn-success" onclick="refreshStats()">
                            <i class="fas fa-sync"></i>
                            Statistiken aktualisieren
                        </button>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h2><i class="fas fa-info-circle"></i> Cache Informationen</h2>
                </div>
                <div class="card-body">
                    <div class="info-grid">
                        <div class="info-item">
                            <strong>Datenbank-Cache:</strong>
                            <span>30 Minuten TTL</span>
                        </div>
                        <div class="info-item">
                            <strong>HTML-Cache:</strong>
                            <span>1 Stunde TTL</span>
                        </div>
                        <div class="info-item">
                            <strong>Cache-Verzeichnis:</strong>
                            <span>/cache/</span>
                        </div>
                        <div class="info-item">
                            <strong>Automatische Bereinigung:</strong>
                            <span>Bei jedem Aufruf</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function clearAllCache() {
            if (confirm('Möchten Sie wirklich alle Caches leeren?')) {
                const form = document.createElement('form');
                form.method = 'POST';
                form.innerHTML = '<input type="hidden" name="action" value="clear_cache">';
                document.body.appendChild(form);
                form.submit();
            }
        }

        function cleanupCache() {
            if (confirm('Möchten Sie abgelaufene Cache-Einträge bereinigen?')) {
                const form = document.createElement('form');
                form.method = 'POST';
                form.innerHTML = '<input type="hidden" name="action" value="clear_cache">';
                document.body.appendChild(form);
                form.submit();
            }
        }

        function refreshStats() {
            location.reload();
        }
    </script>

    <style>
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
        }

        .stat-card {
            display: flex;
            align-items: center;
            gap: 1rem;
            padding: 1rem;
            background: #f8fafc;
            border-radius: 8px;
            border: 1px solid #e2e8f0;
        }

        .stat-icon {
            font-size: 2rem;
            color: var(--volvo-blue);
        }

        .stat-number {
            font-size: 1.5rem;
            font-weight: 700;
            color: #1e293b;
        }

        .stat-label {
            font-size: 0.875rem;
            color: #6b7280;
        }

        .action-buttons {
            display: flex;
            gap: 1rem;
            flex-wrap: wrap;
        }

        .info-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1rem;
        }

        .info-item {
            display: flex;
            justify-content: space-between;
            padding: 0.5rem 0;
            border-bottom: 1px solid #e2e8f0;
        }
    </style>
</body>
</html>
