<?php
/**
 * Simple Test of Suspend Functionality
 */

session_start();
$_SESSION['admin_logged_in'] = true;
$_SESSION['admin_user_id'] = 1;

echo "Testing suspend functionality...\n";

try {
    require_once '../config/database.php';
    $db = new Database();
    $conn = $db->getConnection();
    
    $userId = 10;
    $action = 'suspend';
    $reason = 'Test suspension';
    
    echo "Testing with user_id: $userId\n";
    
    // Get current user status
    $checkSql = "SELECT status FROM users WHERE id = :user_id";
    $checkStmt = $conn->prepare($checkSql);
    $checkStmt->execute([':user_id' => $userId]);
    $user = $checkStmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$user) {
        echo "❌ User not found\n";
        exit;
    }
    
    echo "✅ User found, current status: " . $user['status'] . "\n";
    
    $newStatus = ($action === 'suspend') ? 'suspended' : 'pending';
    
    // Update user status
    $updateSql = "UPDATE users SET status = :status WHERE id = :user_id";
    $updateStmt = $conn->prepare($updateSql);
    $result = $updateStmt->execute([
        ':status' => $newStatus,
        ':user_id' => $userId
    ]);
    
    if ($result) {
        echo "✅ User status updated successfully to: $newStatus\n";
        
        // Test admin action logging
        try {
            $logSql = "INSERT INTO admin_actions (admin_id, user_id, action, reason, created_at) VALUES (:admin_id, :user_id, :action, :reason, NOW())";
            $logStmt = $conn->prepare($logSql);
            $logStmt->execute([
                ':admin_id' => $_SESSION['admin_user_id'],
                ':user_id' => $userId,
                ':action' => $action,
                ':reason' => $reason
            ]);
            echo "✅ Admin action logged successfully\n";
        } catch (Exception $logError) {
            echo "❌ Failed to log admin action: " . $logError->getMessage() . "\n";
        }
        
        // Test user notification
        try {
            $notificationSql = "INSERT INTO user_notifications (user_id, title, message, type, created_at) VALUES (:user_id, :title, :message, :type, NOW())";
            $notificationStmt = $conn->prepare($notificationSql);
            
            $title = 'Account gesperrt';
            $message = 'Ihr Account wurde von einem Administrator gesperrt.' . ($reason ? ' Grund: ' . $reason : '');
            $type = 'warning';
            
            $notificationStmt->execute([
                ':user_id' => $userId,
                ':title' => $title,
                ':message' => $message,
                ':type' => $type
            ]);
            echo "✅ User notification created successfully\n";
        } catch (Exception $notificationError) {
            echo "❌ Failed to create user notification: " . $notificationError->getMessage() . "\n";
        }
        
        echo "✅ All tests passed!\n";
        
    } else {
        echo "❌ Failed to update user status\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}
?>
