// KORREKTES Spalten-Mapping basierend auf Debug-Output

// Debug zeigte: 
// Zeile 1:  | Zur Rücklieferung... | 9.717.936 | Ostsee Apotheke | PLÖ-MA133 | YV1ZZL1V0P2106840 | ...

// Wir müssen die Spalten-INDIZES anpassen:
const cells = row.querySelectorAll('td');

// Index-Basierte Zuweisung (GARANTIERT RICHTIG):
const satznummer = cells[1]?.textContent.trim();  // Index 1 = "9.717.936"
const kundenname = cells[2]?.textContent.trim();  // Index 2 = "Ostsee Apotheke"
const kennzeichen = cells[3]?.textContent.trim();  // Index 3 = "PLÖ-MA133"
const fin = cells[4]?.textContent.trim();  // Index 4 = "YV1ZZL1V0P2106840"

// DEBUG AUSGABE:
console.log(`DEBUG: cells[1]="${cells[1]?.textContent.trim()}", cells[2]="${cells[2]?.textContent.trim()}", cells[3]="${cells[3]?.textContent.trim()}"`);

// Dann in data.push:
data.push({
    kennzeichen: kennzeichen,  // "PLÖ-MA133"
    satznummer: satznummer,  // "9.717.936"
    modell: kundenname,  // "Ostsee Apotheke"
    oe_nummer: satznummer,  // "9.717.936"
    marke: 'RESY',
    reifengroesse: '',  // Nicht in HTML
    fin: fin,
    eingangsdatum: cells[7]?.textContent.trim() || ''
});

