<?php
// CLI only
if (php_sapi_name() !== 'cli') { echo "CLI only\n"; exit(1); }
require_once __DIR__ . '/../config/database.php';

try {
  $db = new Database();
  $conn = $db->getConnection();

  // api_keys
  $conn->exec("CREATE TABLE IF NOT EXISTS api_keys (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(100) NOT NULL,
    key_hash CHAR(64) NOT NULL UNIQUE,
    secret_hash CHAR(64) NOT NULL,
    scopes TEXT NOT NULL,
    is_active TINYINT(1) NOT NULL DEFAULT 1,
    rate_limit_per_min INT NOT NULL DEFAULT 60,
    owner_type VARCHAR(20) DEFAULT 'admin',
    owner_id INT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    last_used_at TIMESTAMP NULL
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

  // api_key_usage (ohne FK, nur Referenzfeld)
  $conn->exec("CREATE TABLE IF NOT EXISTS api_key_usage (
    id BIGINT AUTO_INCREMENT PRIMARY KEY,
    api_key_id INT NOT NULL,
    endpoint VARCHAR(255) NOT NULL,
    http_method VARCHAR(10) NOT NULL,
    status_code INT NOT NULL,
    request_ts TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    ip VARCHAR(64) NULL,
    bytes_in INT DEFAULT 0,
    bytes_out INT DEFAULT 0,
    INDEX(api_key_id, request_ts)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

  // api_replay_nonce (ohne FK, nur Referenzfeld)
  $conn->exec("CREATE TABLE IF NOT EXISTS api_replay_nonce (
    id BIGINT AUTO_INCREMENT PRIMARY KEY,
    api_key_id INT NOT NULL,
    nonce VARCHAR(64) NOT NULL,
    ts TIMESTAMP NOT NULL,
    UNIQUE KEY uq_nonce (api_key_id, nonce)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

  echo "OK: Tabellen vorhanden/erstellt.\n";
} catch (Throwable $e) {
  echo "ERROR: ".$e->getMessage()."\n";
  exit(1);
}
