<?php
/**
 * Lösung mit echten Session-Cookies aus dem Browser
 * Diese Lösung verwendet die tatsächlichen Cookies aus Ihrer Browser-Session
 */

echo "=== LÖSUNG MIT ECHTEN SESSION-COOKIES ===\n";

$testConfig = [
    'base_url' => 'https://resy.dtm-reifen.de',
    'working_lgs_id' => '9716706'
];

/**
 * Verwendet die echten Session-Cookies aus dem Browser
 */
function searchWithRealCookies($baseUrl, $targetLgsId) {
    echo "--- Schritt 1: Verwende echte Session-Cookies ---\n";
    
    // Echte Cookies aus dem Browser (aus der Cookie-Tabelle)
    $realCookies = [
        'PHPSESSID=0b8ctmiebkumf369hsh8pk4004',
        'Autohaus_LastChange=1758805289',
        'Autohaus_Usage[453]=13',
        'HideWheelsetSearchResultFLGFEHL_FLG=1',
        'HideWheelsetSearchResultMINPROFIL=1',
        'HideWheelsetSearchResultPRUFDOC_ID=1',
        'HideWheelsetSearchResultRADKAPFEHL_FLG=1',
        'HideWheelsetSearchResultRFFEHL_FLG=1',
        'HideWheelsetSearchResultSTATUS_ID=1',
        'Ladeplatz_LastChange=1758805289',
        'Ladeplatz_Usage[]=1',
        'Ladeplatz_Usage[0]=1',
        'Ladeplatz_Usage[1]=1',
        'SortConfirmTableCol=2',
        'SortConfirmTableDesc=1',
        'SortWheelsetSearchResultCol=11',
        'SortWheelsetSearchResultDesc=-1'
    ];
    
    $cookieString = implode('; ', $realCookies);
    echo "Verwende " . count($realCookies) . " echte Cookies\n";
    echo "PHPSESSID: 0b8ctmiebkumf369hsh8pk4004\n";
    
    $ch = curl_init();
    
    // Optimierte cURL-Konfiguration mit echten Cookies
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36');
    
    // Wichtige Session-Parameter
    curl_setopt($ch, CURLOPT_COOKIESESSION, false);
    curl_setopt($ch, CURLOPT_FRESH_CONNECT, false);
    curl_setopt($ch, CURLOPT_AUTOREFERER, true);
    curl_setopt($ch, CURLOPT_MAXREDIRS, 10);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    // Verwende die echten Cookies
    curl_setopt($ch, CURLOPT_COOKIE, $cookieString);
    
    echo "--- Schritt 2: Teste direkte URL mit echten Cookies ---\n";
    
    // Verwende die exakte URL-Struktur aus dem Browser-Screenshot
    $directSearchUrl = $baseUrl . '/resyweb/index.php?' . http_build_query([
        'FN' => 'WheelsetSearch',
        'a' => 'search',
        'm' => 'wheelset',
        'LGS_ID' => $targetLgsId,
        'KENNZEICHEN' => '',
        'FAHRGESTNR' => '',
        'BEZEICHNUNG' => '',
        'KDNR' => '',
        'NAME1' => '',
        'EXTDTANR' => '',
        'KD_ID' => '',
        'SERV_ID' => '',
        'STATUS_ID' => '20',
        'SAIS_ID' => '',
        'FROMEINGANGFROM' => '',
        'TOEINGANGTO' => '',
        'FROMPRUEFUNGERLEGIGTFROM' => '',
        'TOPRUEFUNGERLEGIGTTO' => '',
        'RUECKKDNAME' => '',
        'FROMRUECKLIEFERTERMINFROM' => '',
        'TORUECKLIEFERTERMINTO' => '',
        'FROMAUSGANGFROM' => '',
        'TOAUSGANGTO' => '',
        'RFARTSUCH_ID' => '',
        'FROMMINPROFILFROM' => '',
        'TOMINPROFILTO' => '',
        'MAXEMPFEHL_ID' => '',
        'RFFEHL_FLG' => '',
        'FLGFEHL_FLG' => '',
        'RADKAPFEHL_FLG' => '',
        'button' => 'submit'
    ]);
    
    echo "Direkte Such-URL: $directSearchUrl\n";
    
    curl_setopt($ch, CURLOPT_URL, $directSearchUrl);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8',
        'Accept-Language: de-DE,de;q=0.9,en-US;q=0.8,en;q=0.7',
        'Accept-Encoding: gzip, deflate, br, zstd',
        'Connection: keep-alive',
        'Upgrade-Insecure-Requests: 1',
        'Referer: ' . $baseUrl . '/resyweb/index.php'
    ]);
    
    $searchResponse = curl_exec($ch);
    $searchCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $searchFinalUrl = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL);
    
    echo "Suche: HTTP $searchCode, Final URL: $searchFinalUrl\n";
    echo "Content Length: " . strlen($searchResponse) . " Zeichen\n";
    
    // Speichere die Antwort
    file_put_contents(sys_get_temp_dir() . "/resy_real_cookies_result.html", $searchResponse);
    
    curl_close($ch);
    
    // Analysiere die Antwort
    $hasWheelsetData = strpos($searchResponse, 'WheelHALTERNAME') !== false || 
                      strpos($searchResponse, 'WheelKENNZEICHEN') !== false ||
                      strpos($searchResponse, 'WheelFAHRGESTNR') !== false;
    $hasTargetLgsId = strpos($searchResponse, $targetLgsId) !== false;
    $hasLoginForm = strpos($searchResponse, 'Anmeldename') !== false;
    $hasResyContent = strpos($searchResponse, 'RESY') !== false;
    $hasSearchResults = strpos($searchResponse, 'WheelsetSearchResult') !== false;
    
    echo "\n=== ANALYSE MIT ECHTEN COOKIES ===\n";
    echo "Enthält Wheelset-Daten: " . ($hasWheelsetData ? 'Ja' : 'Nein') . "\n";
    echo "Enthält Ziel-LGS_ID: " . ($hasTargetLgsId ? 'Ja' : 'Nein') . "\n";
    echo "Ist Login-Seite: " . ($hasLoginForm ? 'Ja' : 'Nein') . "\n";
    echo "Enthält RESY-Content: " . ($hasResyContent ? 'Ja' : 'Nein') . "\n";
    echo "Enthält Suchergebnisse: " . ($hasSearchResults ? 'Ja' : 'Nein') . "\n";
    
    if ($hasWheelsetData && $hasTargetLgsId) {
        echo "\n🎉 ERFOLG! Echte Cookies funktionieren!\n";
        echo "Wheelset-Daten für LGS_ID $targetLgsId gefunden!\n";
        
        // Extrahiere einige Daten
        if (preg_match('/WheelHALTERNAME[^>]*>([^<]+)/', $searchResponse, $matches)) {
            echo "Fahrzeughalter: " . trim($matches[1]) . "\n";
        }
        if (preg_match('/WheelKENNZEICHEN[^>]*>([^<]+)/', $searchResponse, $matches)) {
            echo "Kennzeichen: " . trim($matches[1]) . "\n";
        }
        if (preg_match('/WheelFAHRGESTNR[^>]*>([^<]+)/', $searchResponse, $matches)) {
            echo "Fahrgestellnummer: " . trim($matches[1]) . "\n";
        }
        
        return [
            'success' => true,
            'lgs_id' => $targetLgsId,
            'search_method' => 'real_cookies',
            'message' => "LGS_ID $targetLgsId mit echten Cookies gefunden",
            'response' => [
                'body' => $searchResponse,
                'http_code' => $searchCode,
                'final_url' => $searchFinalUrl
            ]
        ];
        
    } elseif ($hasLoginForm) {
        throw new Exception("Session ungültig - zur Login-Seite umgeleitet");
    } elseif ($hasResyContent && $hasSearchResults) {
        echo "\n⚠️ RESY-Suchergebnisse gefunden, aber keine Wheelset-Daten\n";
        echo "Die LGS_ID existiert möglicherweise nicht oder hat andere Daten.\n";
        throw new Exception("Keine Wheelset-Daten gefunden");
    } else {
        throw new Exception("Unbekannte Antwort");
    }
}

try {
    echo "Teste Lösung mit echten Cookies und LGS_ID: " . $testConfig['working_lgs_id'] . "\n\n";
    
    $result = searchWithRealCookies(
        $testConfig['base_url'],
        $testConfig['working_lgs_id']
    );
    
    echo "\n✅ Lösung mit echten Cookies erfolgreich!\n";
    echo "Suchmethode: " . $result['search_method'] . "\n";
    echo "Nachricht: " . $result['message'] . "\n";
    
} catch (Exception $e) {
    echo "\n❌ Lösung mit echten Cookies fehlgeschlagen: " . $e->getMessage() . "\n";
    
    // Zeige detaillierte Fehlerinformationen
    echo "\n--- DETAILLIERTE FEHLERINFORMATIONEN ---\n";
    echo "Fehler: " . $e->getMessage() . "\n";
    
    // Prüfe die HTML-Antwort
    $htmlFile = sys_get_temp_dir() . "/resy_real_cookies_result.html";
    if (file_exists($htmlFile)) {
        $content = file_get_contents($htmlFile);
        echo "HTML-Content Length: " . strlen($content) . " Zeichen\n";
        
        // Zeige ersten Teil der Antwort
        echo "\n--- HTML-AUSSCHNITT (erste 500 Zeichen) ---\n";
        echo substr($content, 0, 500) . "\n";
    }
}

echo "\n=== LÖSUNG MIT ECHTEN COOKIES ABGESCHLOSSEN ===\n";
echo "HTML-Datei gespeichert in: " . sys_get_temp_dir() . "/resy_real_cookies_result.html\n";
?>
