<?php
/**
 * Manuelle RESY-Suche um verfügbare LGS_IDs zu finden
 */

require_once 'api/resy_data_extraction_breakthrough.php';

echo "=== MANUELLE RESY-SUCHE ===\n";

$testConfig = [
    'base_url' => 'https://resy.dtm-reifen.de',
    'username' => 'D.ULUDAG',
    'password' => 'Ikizler123!'
];

try {
    // Login durchführen
    echo "--- Login durchführen ---\n";
    performBreakthroughLogin($testConfig['base_url'], $testConfig['username'], $testConfig['password']);
    echo "✅ Login erfolgreich\n\n";
    
    // Session validieren
    $sessionValid = validateResySession($testConfig['base_url']);
    if (!$sessionValid) {
        throw new Exception("Session ungültig nach Login");
    }
    echo "✅ Session gültig\n\n";
    
    // Teste verschiedene bekannte LGS_IDs
    $testLgsIds = [
        '9877038',  // Die ursprüngliche LGS_ID
        '9718476',  // Eine bekannte funktionierende LGS_ID
        '971847',   // Teil der bekannten LGS_ID
        '718476',   // Anderer Teil
        '9877131',  // Ähnliche LGS_ID
        '987703',   // Teil der ursprünglichen
        '877038',   // Anderer Teil
        '1234567',  // Test-LGS_ID
        '9999999'   // Test-LGS_ID
    ];
    
    echo "--- Teste verschiedene LGS_IDs ---\n";
    
    foreach ($testLgsIds as $lgsId) {
        echo "Teste LGS_ID: $lgsId\n";
        
        try {
            $searchResult = searchWithUpdatedResySystem($testConfig['base_url'], $lgsId);
            echo "✅ GEFUNDEN: LGS_ID $lgsId mit Strategie {$searchResult['search_type']}\n";
            echo "   Suchbegriff: {$searchResult['search_term']}\n";
            echo "   Gefundene LGS_ID: {$searchResult['lgs_id']}\n\n";
            
            // Wenn wir eine funktionierende LGS_ID gefunden haben, breche ab
            break;
            
        } catch (Exception $e) {
            echo "❌ Nicht gefunden: " . $e->getMessage() . "\n\n";
        }
    }
    
    // Teste auch eine leere Suche um zu sehen, was das RESY-System zurückgibt
    echo "--- Teste leere Suche ---\n";
    try {
        $emptySearchUrl = $testConfig['base_url'] . '/index.php?m=wheelset&a=search';
        $response = httpRequest($emptySearchUrl, [
            'headers' => [
                'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36',
                'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8',
                'Accept-Language: de-DE,de;q=0.9,en;q=0.8',
                'Referer: ' . $testConfig['base_url']
            ]
        ]);
        
        echo "Leere Suche Response Code: " . $response['http_code'] . "\n";
        echo "Leere Suche Final URL: " . $response['final_url'] . "\n";
        
        // Speichere die Antwort für Analyse
        file_put_contents(sys_get_temp_dir() . '/resy_empty_search.html', $response['body']);
        echo "Leere Suche HTML gespeichert in: " . sys_get_temp_dir() . '/resy_empty_search.html' . "\n";
        
        // Analysiere den Inhalt
        if (strpos($response['body'], 'LGS_ID') !== false) {
            echo "✅ Leere Suche enthält LGS_ID-Felder\n";
        }
        if (strpos($response['body'], 'Wheelset') !== false) {
            echo "✅ Leere Suche enthält Wheelset-Referenzen\n";
        }
        if (strpos($response['body'], 'search') !== false) {
            echo "✅ Leere Suche enthält Such-Funktionalität\n";
        }
        
    } catch (Exception $e) {
        echo "❌ Leere Suche fehlgeschlagen: " . $e->getMessage() . "\n";
    }
    
} catch (Exception $e) {
    echo "❌ Test fehlgeschlagen: " . $e->getMessage() . "\n";
}

echo "\n=== TEST ABGESCHLOSSEN ===\n";
?>
