<?php
/**
 * KORRIGIERTE RESY API - Mit funktionierender Cookie-Lösung
 * Diese Version repariert den Syntax-Fehler und integriert die finale Lösung
 */

// Kopiere den gesamten Inhalt der ursprünglichen API
$originalApiContent = file_get_contents('api/resy_data_extraction_breakthrough.php');

// Finde die problematische Funktion und ersetze sie
$problematicFunctionStart = strpos($originalApiContent, 'function searchWithRealSessionCookies($baseUrl, $targetLgsId) {');
$problematicFunctionEnd = strpos($originalApiContent, '}', $problematicFunctionStart);

// Finde das Ende der problematischen Funktion (bis zur nächsten Funktion)
$nextFunctionStart = strpos($originalApiContent, 'function ', $problematicFunctionStart + 1);
if ($nextFunctionStart === false) {
    $nextFunctionStart = strlen($originalApiContent);
}

// Erstelle die korrigierte Funktion
$correctedFunction = 'function searchWithRealSessionCookies($baseUrl, $targetLgsId) {
    debugLog("=== SEARCH WITH REAL SESSION COOKIES START ===");
    debugLog("Target LGS_ID: $targetLgsId");
    
    // Echte Cookies aus dem Browser (funktionieren nachweislich)
    $realCookies = [
        "PHPSESSID=0b8ctmiebkumf369hsh8pk4004",
        "Autohaus_LastChange=1758805289",
        "Autohaus_Usage[453]=13",
        "HideWheelsetSearchResultFLGFEHL_FLG=1",
        "HideWheelsetSearchResultMINPROFIL=1",
        "HideWheelsetSearchResultPRUFDOC_ID=1",
        "HideWheelsetSearchResultRADKAPFEHL_FLG=1",
        "HideWheelsetSearchResultRFFEHL_FLG=1",
        "HideWheelsetSearchResultSTATUS_ID=1",
        "Ladeplatz_LastChange=1758805289",
        "Ladeplatz_Usage[]=1",
        "Ladeplatz_Usage[0]=1",
        "Ladeplatz_Usage[1]=1",
        "SortConfirmTableCol=2",
        "SortConfirmTableDesc=1",
        "SortWheelsetSearchResultCol=11",
        "SortWheelsetSearchResultDesc=-1"
    ];
    
    $cookieString = implode("; ", $realCookies);
    debugLog("Verwende " . count($realCookies) . " echte Cookies");
    debugLog("PHPSESSID: 0b8ctmiebkumf369hsh8pk4004");
    
    $ch = curl_init();
    
    // Optimierte cURL-Konfiguration mit echten Cookies
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36");
    
    // Wichtige Session-Parameter
    curl_setopt($ch, CURLOPT_COOKIESESSION, false);
    curl_setopt($ch, CURLOPT_FRESH_CONNECT, false);
    curl_setopt($ch, CURLOPT_AUTOREFERER, true);
    curl_setopt($ch, CURLOPT_MAXREDIRS, 10);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    // Verwende die echten Cookies
    curl_setopt($ch, CURLOPT_COOKIE, $cookieString);
    
    debugLog("--- Verwende exakte URL-Struktur aus Browser-Screenshot ---");
    
    // Verwende die exakte URL-Struktur aus dem Browser-Screenshot
    $directSearchUrl = $baseUrl . "/resyweb/index.php?" . http_build_query([
        "FN" => "WheelsetSearch",
        "a" => "search",
        "m" => "wheelset",
        "LGS_ID" => $targetLgsId,
        "KENNZEICHEN" => "",
        "FAHRGESTNR" => "",
        "BEZEICHNUNG" => "",
        "KDNR" => "",
        "NAME1" => "",
        "EXTDTANR" => "",
        "KD_ID" => "",
        "SERV_ID" => "",
        "STATUS_ID" => "20",
        "SAIS_ID" => "",
        "FROMEINGANGFROM" => "",
        "TOEINGANGTO" => "",
        "FROMPRUEFUNGERLEGIGTFROM" => "",
        "TOPRUEFUNGERLEGIGTTO" => "",
        "RUECKKDNAME" => "",
        "FROMRUECKLIEFERTERMINFROM" => "",
        "TORUECKLIEFERTERMINTO" => "",
        "FROMAUSGANGFROM" => "",
        "TOAUSGANGTO" => "",
        "RFARTSUCH_ID" => "",
        "FROMMINPROFILFROM" => "",
        "TOMINPROFILTO" => "",
        "MAXEMPFEHL_ID" => "",
        "RFFEHL_FLG" => "",
        "FLGFEHL_FLG" => "",
        "RADKAPFEHL_FLG" => "",
        "button" => "submit"
    ]);
    
    debugLog("Direkte Such-URL: $directSearchUrl");
    
    curl_setopt($ch, CURLOPT_URL, $directSearchUrl);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8",
        "Accept-Language: de-DE,de;q=0.9,en-US;q=0.8,en;q=0.7",
        "Accept-Encoding: gzip, deflate, br, zstd",
        "Connection: keep-alive",
        "Upgrade-Insecure-Requests: 1",
        "Referer: " . $baseUrl . "/resyweb/index.php"
    ]);
    
    $searchResponse = curl_exec($ch);
    $searchCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $searchFinalUrl = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL);
    
    debugLog("Suche: HTTP $searchCode, Final URL: $searchFinalUrl");
    debugLog("Content Length: " . strlen($searchResponse) . " Zeichen");
    
    // Dekodiere gzip-komprimierte Antwort falls nötig
    if (substr($searchResponse, 0, 2) === "\x1f\x8b") {
        $searchResponse = gzdecode($searchResponse);
        debugLog("Gzip-komprimierte Antwort dekodiert");
    }
    
    // Speichere die Antwort für Debugging
    file_put_contents(sys_get_temp_dir() . "/resy_real_cookies_$targetLgsId.html", $searchResponse);
    
    curl_close($ch);
    
    // Analysiere die Antwort
    $hasWheelsetData = strpos($searchResponse, "WheelHALTERNAME") !== false || 
                      strpos($searchResponse, "WheelKENNZEICHEN") !== false ||
                      strpos($searchResponse, "WheelFAHRGESTNR") !== false;
    $hasTargetLgsId = strpos($searchResponse, $targetLgsId) !== false;
    $hasLoginForm = strpos($searchResponse, "Anmeldename") !== false;
    $hasResyContent = strpos($searchResponse, "RESY") !== false;
    $hasSearchResults = strpos($searchResponse, "WheelsetSearchResult") !== false;
    
    debugLog("=== ANALYSE MIT ECHTEN COOKIES ===");
    debugLog("Enthält Wheelset-Daten: " . ($hasWheelsetData ? "Ja" : "Nein"));
    debugLog("Enthält Ziel-LGS_ID: " . ($hasTargetLgsId ? "Ja" : "Nein"));
    debugLog("Ist Login-Seite: " . ($hasLoginForm ? "Ja" : "Nein"));
    debugLog("Enthält RESY-Content: " . ($hasResyContent ? "Ja" : "Nein"));
    debugLog("Enthält Suchergebnisse: " . ($hasSearchResults ? "Ja" : "Nein"));
    
    if ($hasWheelsetData && $hasTargetLgsId) {
        debugLog("🎉 ERFOLG! Echte Cookies funktionieren!");
        debugLog("Wheelset-Daten für LGS_ID $targetLgsId gefunden!");
        
        debugLog("=== SEARCH WITH REAL SESSION COOKIES END ===");
        return [
            "success" => true,
            "lgs_id" => $targetLgsId,
            "search_method" => "real_cookies",
            "message" => "LGS_ID $targetLgsId mit echten Cookies gefunden",
            "response" => [
                "body" => $searchResponse,
                "http_code" => $searchCode,
                "final_url" => $searchFinalUrl
            ]
        ];
        
    } elseif ($hasLoginForm) {
        throw new Exception("Session ungültig - zur Login-Seite umgeleitet");
    } elseif ($hasResyContent && $hasSearchResults) {
        debugLog("⚠️ RESY-Suchergebnisse gefunden, aber keine Wheelset-Daten");
        debugLog("Die LGS_ID existiert möglicherweise nicht oder hat andere Daten.");
        throw new Exception("Keine Wheelset-Daten gefunden");
    } else {
        throw new Exception("Unbekannte Antwort");
    }
}';

// Erstelle die korrigierte API
$correctedApiContent = substr($originalApiContent, 0, $problematicFunctionStart) . 
                      $correctedFunction . 
                      substr($originalApiContent, $nextFunctionStart);

// Speichere die korrigierte API
file_put_contents('api/resy_data_extraction_breakthrough_corrected.php', $correctedApiContent);

echo "✅ API korrigiert und gespeichert als: api/resy_data_extraction_breakthrough_corrected.php\n";
echo "Die korrigierte API ist bereit für den Einsatz!\n";
?>
