<?php
/**
 * Finaler Test für die RESY-API mit verbesserter Session-Verwaltung
 */

require_once 'api/resy_data_extraction_breakthrough.php';

echo "=== FINALER RESY-API TEST ===\n";

// Test-Konfiguration
$testConfig = [
    'base_url' => 'https://resy.dtm-reifen.de',
    'username' => 'D.ULUDAG',
    'password' => 'Ikizler123!',
    'test_lgs_id' => '9877038'
];

echo "Base URL: " . $testConfig['base_url'] . "\n";
echo "Test LGS_ID: " . $testConfig['test_lgs_id'] . "\n\n";

try {
    // Simuliere einen echten API-Aufruf
    echo "--- Simuliere echten API-Aufruf ---\n";
    
    $input = [
        'action' => 'breakthrough',
        'appointment_id' => 100,
        'lgsId' => $testConfig['test_lgs_id']
    ];
    
    // Simuliere die API-Logik direkt
    echo "🔄 Führe Login durch...\n";
    performBreakthroughLogin($testConfig['base_url'], $testConfig['username'], $testConfig['password']);
    echo "✅ Login erfolgreich\n";
    
    echo "🔄 Führe sofortige Suche durch...\n";
    $searchResult = searchWithWorkingLgsIds($testConfig['base_url'], $testConfig['test_lgs_id']);
    echo "✅ Suche erfolgreich!\n";
    echo "Gefundene LGS_ID: " . $searchResult['lgs_id'] . "\n";
    echo "Suchstrategie: " . ($searchResult['search_type'] ?? $searchResult['search_method'] ?? 'unbekannt') . "\n";
    
    echo "🔄 Navigiere zur Detailseite...\n";
    $detailResponse = navigateToDetailPageBreakthrough($testConfig['base_url'], $searchResult['lgs_id']);
    echo "✅ Detailseite erreicht!\n";
    echo "Response Code: " . $detailResponse['http_code'] . "\n";
    echo "Content Length: " . strlen($detailResponse['body']) . " Zeichen\n";
    
    // Prüfe ob es eine echte Detailseite ist
    $hasWheelData = strpos($detailResponse['body'], 'WheelHALTERNAME') !== false ||
                    strpos($detailResponse['body'], 'WheelKENNZEICHEN') !== false ||
                    strpos($detailResponse['body'], 'WheelFAHRGESTNR') !== false;
    
    if ($hasWheelData) {
        echo "✅ Echte Detailseite mit Fahrzeugdaten gefunden!\n";
        
        // Extrahiere einige Daten
        try {
            $vehicleData = [];
            $fields = ['fahrzeughalter', 'kennzeichen', 'fin'];
            foreach ($fields as $field) {
                $value = extractDataFromHtml($detailResponse['body'], $field);
                $vehicleData[$field] = $value;
                echo "  $field: $value\n";
            }
        } catch (Exception $e) {
            echo "⚠️ Fehler beim Extrahieren der Fahrzeugdaten: " . $e->getMessage() . "\n";
        }
        
    } else {
        echo "❌ Keine echten Fahrzeugdaten auf der Detailseite gefunden\n";
    }
    
} catch (Exception $e) {
    echo "❌ Test fehlgeschlagen: " . $e->getMessage() . "\n";
    
    // Zeige detaillierte Fehlerinformationen
    echo "\n--- DETAILLIERTE FEHLERINFORMATIONEN ---\n";
    echo "Fehler: " . $e->getMessage() . "\n";
    echo "Datei: " . $e->getFile() . "\n";
    echo "Zeile: " . $e->getLine() . "\n";
    
    // Prüfe die Logs
    $logFile = 'logs/resy_extraction.log';
    if (file_exists($logFile)) {
        echo "\n--- LETZTE LOG-EINTRÄGE ---\n";
        $logs = file($logFile);
        $lastLogs = array_slice($logs, -10);
        foreach ($lastLogs as $log) {
            echo trim($log) . "\n";
        }
    }
}

echo "\n=== TEST ABGESCHLOSSEN ===\n";
echo "Prüfen Sie die Logs in: logs/resy_extraction.log\n";
echo "Prüfen Sie die HTML-Dateien in: " . sys_get_temp_dir() . "/\n";
?>
