<?php
// Debugge das Tabellen-Parsing spezifisch
require_once 'api/get_stored_wheelsets.php';

// Lade die gespeicherte HTML-Antwort
$htmlFile = sys_get_temp_dir() . '/resy_wheelsets_response_1.html';

if (file_exists($htmlFile)) {
    $html = file_get_contents($htmlFile);
    echo "<h1>Tabellen-Parsing Debug</h1>";
    echo "<p>HTML-Datei gefunden: " . strlen($html) . " bytes</p>";
    
    // Suche nach Tabellen
    $patterns = [
        '/<tbody[^>]*>(.*?)<\/tbody>/s',
        '/<table[^>]*class="[^"]*table[^"]*"[^>]*>(.*?)<\/table>/s',
        '/<table[^>]*>(.*?)<\/table>/s',
        '/<div[^>]*class="[^"]*table[^"]*"[^>]*>(.*?)<\/div>/s'
    ];
    
    foreach ($patterns as $patternIndex => $pattern) {
        echo "<h2>Pattern " . ($patternIndex + 1) . ": " . $pattern . "</h2>";
        
        if (preg_match_all($pattern, $html, $matches)) {
            echo "<p>✅ Gefunden: " . count($matches[1]) . " Tabellen</p>";
            
            foreach ($matches[1] as $tableIndex => $tableHtml) {
                echo "<h3>Tabelle " . ($tableIndex + 1) . " (Länge: " . strlen($tableHtml) . " Zeichen)</h3>";
                
                // Suche nach Zeilen
                if (preg_match_all('/<tr[^>]*>(.*?)<\/tr>/s', $tableHtml, $rows)) {
                    echo "<p>Gefundene Zeilen: " . count($rows[1]) . "</p>";
                    
                    foreach ($rows[1] as $rowIndex => $row) {
                        echo "<h4>Zeile " . $rowIndex . "</h4>";
                        
                        // Suche nach Zellen
                        if (preg_match_all('/<td[^>]*>(.*?)<\/td>/s', $row, $cells)) {
                            $cells = $cells[1];
                            echo "<p>Zellen: " . count($cells) . "</p>";
                            
                            echo "<ul>";
                            foreach ($cells as $cellIndex => $cell) {
                                $cleanCell = trim(strip_tags($cell));
                                echo "<li>Zelle $cellIndex: '" . htmlspecialchars($cleanCell) . "'</li>";
                            }
                            echo "</ul>";
                            
                            // Simuliere das Parsing
                            if (count($cells) >= 2) {
                                $wheelset = [
                                    'satznummer' => trim(strip_tags($cells[0] ?? '')),
                                    'kennzeichen' => trim(strip_tags($cells[1] ?? '')),
                                    'fahrzeug' => trim(strip_tags($cells[2] ?? '')),
                                    'halter' => trim(strip_tags($cells[3] ?? '')),
                                    'eingangsdatum' => trim(strip_tags($cells[4] ?? '')),
                                    'status' => 'eingelagert'
                                ];
                                
                                echo "<h5>Parsed Wheelset:</h5>";
                                echo "<pre>" . print_r($wheelset, true) . "</pre>";
                                
                                // Prüfe ob es ein echter Reifensatz ist
                                $isReal = !empty($wheelset['satznummer']) && 
                                         $wheelset['satznummer'] !== '&nbsp;' && 
                                         strpos($wheelset['satznummer'], 'Anz=') === false;
                                
                                echo "<p>Ist echter Reifensatz: " . ($isReal ? "✅ JA" : "❌ NEIN") . "</p>";
                            }
                        }
                        
                        if ($rowIndex >= 5) break; // Nur erste 6 Zeilen
                    }
                }
            }
        } else {
            echo "<p>❌ Keine Tabellen gefunden</p>";
        }
    }
    
} else {
    echo "<p style='color: red;'>HTML-Datei nicht gefunden: $htmlFile</p>";
}
?>
