<?php
/**
 * Debug-API um den Vorgang zu verfolgen
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

// Aktiviere Error-Logging
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);

echo "=== DEBUG API START ===\n";
error_log("=== DEBUG API START ===");

// Test 1: Database Connection
echo "Test 1: Database Connection\n";
error_log("Test 1: Database Connection");

try {
    require_once 'config/database.php';
    $db = new Database();
    $pdo = $db->getConnection();
    echo "✅ Database Connection erfolgreich\n";
    error_log("✅ Database Connection erfolgreich");
} catch (Exception $e) {
    echo "❌ Database Connection fehlgeschlagen: " . $e->getMessage() . "\n";
    error_log("❌ Database Connection fehlgeschlagen: " . $e->getMessage());
}

// Test 2: Autohaus-Daten laden
echo "\nTest 2: Autohaus-Daten laden\n";
error_log("Test 2: Autohaus-Daten laden");

try {
    $stmt = $pdo->prepare("SELECT id, name, resy_username, resy_password FROM autohaus WHERE id = 1");
    $stmt->execute();
    $autohaus = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($autohaus) {
        echo "✅ Autohaus gefunden: " . $autohaus['name'] . "\n";
        echo "   Username: " . $autohaus['resy_username'] . "\n";
        echo "   Password: " . str_repeat('*', strlen($autohaus['resy_password'])) . "\n";
        error_log("✅ Autohaus gefunden: " . $autohaus['name']);
    } else {
        echo "❌ Kein Autohaus gefunden\n";
        error_log("❌ Kein Autohaus gefunden");
    }
} catch (Exception $e) {
    echo "❌ Fehler beim Laden der Autohaus-Daten: " . $e->getMessage() . "\n";
    error_log("❌ Fehler beim Laden der Autohaus-Daten: " . $e->getMessage());
}

// Test 3: API aufrufen
echo "\nTest 3: API aufrufen\n";
error_log("Test 3: API aufrufen");

try {
    $api = new ProfessionalWheelsetsAPI(1);
    echo "✅ API-Objekt erstellt\n";
    error_log("✅ API-Objekt erstellt");
    
    $result = $api->getStoredWheelsets();
    echo "✅ API-Aufruf abgeschlossen\n";
    echo "   Success: " . ($result['success'] ? 'true' : 'false') . "\n";
    echo "   Count: " . $result['count'] . "\n";
    echo "   Source: " . $result['source'] . "\n";
    error_log("✅ API-Aufruf abgeschlossen - Success: " . ($result['success'] ? 'true' : 'false') . ", Count: " . $result['count']);
    
} catch (Exception $e) {
    echo "❌ Fehler beim API-Aufruf: " . $e->getMessage() . "\n";
    error_log("❌ Fehler beim API-Aufruf: " . $e->getMessage());
}

echo "\n=== DEBUG API ENDE ===\n";
error_log("=== DEBUG API ENDE ===");

// JSON-Response
echo json_encode([
    'success' => true,
    'message' => 'Debug abgeschlossen',
    'timestamp' => date('Y-m-d H:i:s')
]);
?>
